/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionSlideDownBlock;
import net.minecraft.advancements.critereon.CriterionTriggerBeeNestDestroyed;
import net.minecraft.advancements.critereon.CriterionTriggerBredAnimals;
import net.minecraft.advancements.critereon.CriterionTriggerBrewedPotion;
import net.minecraft.advancements.critereon.CriterionTriggerChangedDimension;
import net.minecraft.advancements.critereon.CriterionTriggerChanneledLightning;
import net.minecraft.advancements.critereon.CriterionTriggerConstructBeacon;
import net.minecraft.advancements.critereon.CriterionTriggerConsumeItem;
import net.minecraft.advancements.critereon.CriterionTriggerCuredZombieVillager;
import net.minecraft.advancements.critereon.CriterionTriggerEffectsChanged;
import net.minecraft.advancements.critereon.CriterionTriggerEnchantedItem;
import net.minecraft.advancements.critereon.CriterionTriggerEnterBlock;
import net.minecraft.advancements.critereon.CriterionTriggerEntityHurtPlayer;
import net.minecraft.advancements.critereon.CriterionTriggerFilledBucket;
import net.minecraft.advancements.critereon.CriterionTriggerFishingRodHooked;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.advancements.critereon.CriterionTriggerInventoryChanged;
import net.minecraft.advancements.critereon.CriterionTriggerItemDurabilityChanged;
import net.minecraft.advancements.critereon.CriterionTriggerKilled;
import net.minecraft.advancements.critereon.CriterionTriggerKilledByCrossbow;
import net.minecraft.advancements.critereon.CriterionTriggerLevitation;
import net.minecraft.advancements.critereon.CriterionTriggerPlayerGeneratesContainerLoot;
import net.minecraft.advancements.critereon.CriterionTriggerPlayerHurtEntity;
import net.minecraft.advancements.critereon.CriterionTriggerPlayerInteractedWithEntity;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.advancements.critereon.CriterionTriggerShotCrossbow;
import net.minecraft.advancements.critereon.CriterionTriggerSummonedEntity;
import net.minecraft.advancements.critereon.CriterionTriggerTamedAnimal;
import net.minecraft.advancements.critereon.CriterionTriggerTargetHit;
import net.minecraft.advancements.critereon.CriterionTriggerUsedEnderEye;
import net.minecraft.advancements.critereon.CriterionTriggerUsedTotem;
import net.minecraft.advancements.critereon.CriterionTriggerVillagerTrade;
import net.minecraft.advancements.critereon.DistanceTrigger;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LightningStrikeTrigger;
import net.minecraft.advancements.critereon.PickedUpItemTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.advancements.critereon.StartRidingTrigger;
import net.minecraft.advancements.critereon.UsingItemTrigger;
import net.minecraft.resources.MinecraftKey;

public class CriterionTriggers {
    private static final Map<MinecraftKey, CriterionTrigger<?>> CRITERIA = Maps.newHashMap();
    public static final CriterionTriggerImpossible IMPOSSIBLE = CriterionTriggers.register(new CriterionTriggerImpossible());
    public static final CriterionTriggerKilled PLAYER_KILLED_ENTITY = CriterionTriggers.register(new CriterionTriggerKilled(new MinecraftKey("player_killed_entity")));
    public static final CriterionTriggerKilled ENTITY_KILLED_PLAYER = CriterionTriggers.register(new CriterionTriggerKilled(new MinecraftKey("entity_killed_player")));
    public static final CriterionTriggerEnterBlock ENTER_BLOCK = CriterionTriggers.register(new CriterionTriggerEnterBlock());
    public static final CriterionTriggerInventoryChanged INVENTORY_CHANGED = CriterionTriggers.register(new CriterionTriggerInventoryChanged());
    public static final CriterionTriggerRecipeUnlocked RECIPE_UNLOCKED = CriterionTriggers.register(new CriterionTriggerRecipeUnlocked());
    public static final CriterionTriggerPlayerHurtEntity PLAYER_HURT_ENTITY = CriterionTriggers.register(new CriterionTriggerPlayerHurtEntity());
    public static final CriterionTriggerEntityHurtPlayer ENTITY_HURT_PLAYER = CriterionTriggers.register(new CriterionTriggerEntityHurtPlayer());
    public static final CriterionTriggerEnchantedItem ENCHANTED_ITEM = CriterionTriggers.register(new CriterionTriggerEnchantedItem());
    public static final CriterionTriggerFilledBucket FILLED_BUCKET = CriterionTriggers.register(new CriterionTriggerFilledBucket());
    public static final CriterionTriggerBrewedPotion BREWED_POTION = CriterionTriggers.register(new CriterionTriggerBrewedPotion());
    public static final CriterionTriggerConstructBeacon CONSTRUCT_BEACON = CriterionTriggers.register(new CriterionTriggerConstructBeacon());
    public static final CriterionTriggerUsedEnderEye USED_ENDER_EYE = CriterionTriggers.register(new CriterionTriggerUsedEnderEye());
    public static final CriterionTriggerSummonedEntity SUMMONED_ENTITY = CriterionTriggers.register(new CriterionTriggerSummonedEntity());
    public static final CriterionTriggerBredAnimals BRED_ANIMALS = CriterionTriggers.register(new CriterionTriggerBredAnimals());
    public static final PlayerTrigger LOCATION = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("location")));
    public static final PlayerTrigger SLEPT_IN_BED = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("slept_in_bed")));
    public static final CriterionTriggerCuredZombieVillager CURED_ZOMBIE_VILLAGER = CriterionTriggers.register(new CriterionTriggerCuredZombieVillager());
    public static final CriterionTriggerVillagerTrade TRADE = CriterionTriggers.register(new CriterionTriggerVillagerTrade());
    public static final CriterionTriggerItemDurabilityChanged ITEM_DURABILITY_CHANGED = CriterionTriggers.register(new CriterionTriggerItemDurabilityChanged());
    public static final CriterionTriggerLevitation LEVITATION = CriterionTriggers.register(new CriterionTriggerLevitation());
    public static final CriterionTriggerChangedDimension CHANGED_DIMENSION = CriterionTriggers.register(new CriterionTriggerChangedDimension());
    public static final PlayerTrigger TICK = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("tick")));
    public static final CriterionTriggerTamedAnimal TAME_ANIMAL = CriterionTriggers.register(new CriterionTriggerTamedAnimal());
    public static final ItemUsedOnLocationTrigger PLACED_BLOCK = CriterionTriggers.register(new ItemUsedOnLocationTrigger(new MinecraftKey("placed_block")));
    public static final CriterionTriggerConsumeItem CONSUME_ITEM = CriterionTriggers.register(new CriterionTriggerConsumeItem());
    public static final CriterionTriggerEffectsChanged EFFECTS_CHANGED = CriterionTriggers.register(new CriterionTriggerEffectsChanged());
    public static final CriterionTriggerUsedTotem USED_TOTEM = CriterionTriggers.register(new CriterionTriggerUsedTotem());
    public static final DistanceTrigger NETHER_TRAVEL = CriterionTriggers.register(new DistanceTrigger(new MinecraftKey("nether_travel")));
    public static final CriterionTriggerFishingRodHooked FISHING_ROD_HOOKED = CriterionTriggers.register(new CriterionTriggerFishingRodHooked());
    public static final CriterionTriggerChanneledLightning CHANNELED_LIGHTNING = CriterionTriggers.register(new CriterionTriggerChanneledLightning());
    public static final CriterionTriggerShotCrossbow SHOT_CROSSBOW = CriterionTriggers.register(new CriterionTriggerShotCrossbow());
    public static final CriterionTriggerKilledByCrossbow KILLED_BY_CROSSBOW = CriterionTriggers.register(new CriterionTriggerKilledByCrossbow());
    public static final PlayerTrigger RAID_WIN = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("hero_of_the_village")));
    public static final PlayerTrigger BAD_OMEN = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("voluntary_exile")));
    public static final CriterionSlideDownBlock HONEY_BLOCK_SLIDE = CriterionTriggers.register(new CriterionSlideDownBlock());
    public static final CriterionTriggerBeeNestDestroyed BEE_NEST_DESTROYED = CriterionTriggers.register(new CriterionTriggerBeeNestDestroyed());
    public static final CriterionTriggerTargetHit TARGET_BLOCK_HIT = CriterionTriggers.register(new CriterionTriggerTargetHit());
    public static final ItemUsedOnLocationTrigger ITEM_USED_ON_BLOCK = CriterionTriggers.register(new ItemUsedOnLocationTrigger(new MinecraftKey("item_used_on_block")));
    public static final CriterionTriggerPlayerGeneratesContainerLoot GENERATE_LOOT = CriterionTriggers.register(new CriterionTriggerPlayerGeneratesContainerLoot());
    public static final PickedUpItemTrigger THROWN_ITEM_PICKED_UP_BY_ENTITY = CriterionTriggers.register(new PickedUpItemTrigger(new MinecraftKey("thrown_item_picked_up_by_entity")));
    public static final PickedUpItemTrigger THROWN_ITEM_PICKED_UP_BY_PLAYER = CriterionTriggers.register(new PickedUpItemTrigger(new MinecraftKey("thrown_item_picked_up_by_player")));
    public static final CriterionTriggerPlayerInteractedWithEntity PLAYER_INTERACTED_WITH_ENTITY = CriterionTriggers.register(new CriterionTriggerPlayerInteractedWithEntity());
    public static final StartRidingTrigger START_RIDING_TRIGGER = CriterionTriggers.register(new StartRidingTrigger());
    public static final LightningStrikeTrigger LIGHTNING_STRIKE = CriterionTriggers.register(new LightningStrikeTrigger());
    public static final UsingItemTrigger USING_ITEM = CriterionTriggers.register(new UsingItemTrigger());
    public static final DistanceTrigger FALL_FROM_HEIGHT = CriterionTriggers.register(new DistanceTrigger(new MinecraftKey("fall_from_height")));
    public static final DistanceTrigger RIDE_ENTITY_IN_LAVA_TRIGGER = CriterionTriggers.register(new DistanceTrigger(new MinecraftKey("ride_entity_in_lava")));
    public static final CriterionTriggerKilled KILL_MOB_NEAR_SCULK_CATALYST = CriterionTriggers.register(new CriterionTriggerKilled(new MinecraftKey("kill_mob_near_sculk_catalyst")));
    public static final ItemUsedOnLocationTrigger ALLAY_DROP_ITEM_ON_BLOCK = CriterionTriggers.register(new ItemUsedOnLocationTrigger(new MinecraftKey("allay_drop_item_on_block")));
    public static final PlayerTrigger AVOID_VIBRATION = CriterionTriggers.register(new PlayerTrigger(new MinecraftKey("avoid_vibration")));
    public static final RecipeCraftedTrigger RECIPE_CRAFTED = CriterionTriggers.register(new RecipeCraftedTrigger());

    private static <T extends CriterionTrigger<?>> T register(T var0) {
        if (CRITERIA.containsKey(var0.getId())) {
            throw new IllegalArgumentException("Duplicate criterion id " + var0.getId());
        }
        CRITERIA.put(var0.getId(), var0);
        return var0;
    }

    @Nullable
    public static <T extends CriterionInstance> CriterionTrigger<T> getCriterion(MinecraftKey var0) {
        return CRITERIA.get(var0);
    }

    public static Iterable<? extends CriterionTrigger<?>> all() {
        return CRITERIA.values();
    }
}

