/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdvancementDisplay {
    private final IChatBaseComponent title;
    private final IChatBaseComponent description;
    private final ItemStack icon;
    @Nullable
    private final MinecraftKey background;
    private final AdvancementFrameType frame;
    private final boolean showToast;
    private final boolean announceChat;
    private final boolean hidden;
    private float x;
    private float y;

    public AdvancementDisplay(ItemStack var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
        this.title = var1;
        this.description = var2;
        this.icon = var0;
        this.background = var3;
        this.frame = var4;
        this.showToast = var5;
        this.announceChat = var6;
        this.hidden = var7;
    }

    public void setLocation(float var0, float var1) {
        this.x = var0;
        this.y = var1;
    }

    public IChatBaseComponent getTitle() {
        return this.title;
    }

    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    @Nullable
    public MinecraftKey getBackground() {
        return this.background;
    }

    public AdvancementFrameType getFrame() {
        return this.frame;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean shouldShowToast() {
        return this.showToast;
    }

    public boolean shouldAnnounceChat() {
        return this.announceChat;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static AdvancementDisplay fromJson(JsonObject var0) {
        IChatMutableComponent var1 = IChatBaseComponent.ChatSerializer.fromJson(var0.get("title"));
        IChatMutableComponent var2 = IChatBaseComponent.ChatSerializer.fromJson(var0.get("description"));
        if (var1 == null || var2 == null) {
            throw new JsonSyntaxException("Both title and description must be set");
        }
        ItemStack var3 = AdvancementDisplay.getIcon(ChatDeserializer.getAsJsonObject(var0, "icon"));
        MinecraftKey var4 = var0.has("background") ? new MinecraftKey(ChatDeserializer.getAsString(var0, "background")) : null;
        AdvancementFrameType var5 = var0.has("frame") ? AdvancementFrameType.byName(ChatDeserializer.getAsString(var0, "frame")) : AdvancementFrameType.TASK;
        boolean var6 = ChatDeserializer.getAsBoolean(var0, "show_toast", true);
        boolean var7 = ChatDeserializer.getAsBoolean(var0, "announce_to_chat", true);
        boolean var8 = ChatDeserializer.getAsBoolean(var0, "hidden", false);
        return new AdvancementDisplay(var3, var1, var2, var4, var5, var6, var7, var8);
    }

    private static ItemStack getIcon(JsonObject var0) {
        if (!var0.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item var1 = ChatDeserializer.getAsItem(var0, "item");
        if (var0.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        ItemStack var2 = new ItemStack(var1);
        if (var0.has("nbt")) {
            try {
                NBTTagCompound var3 = MojangsonParser.parseTag(ChatDeserializer.convertToString(var0.get("nbt"), "nbt"));
                var2.setTag(var3);
            }
            catch (CommandSyntaxException var3) {
                throw new JsonSyntaxException("Invalid nbt tag: " + var3.getMessage());
            }
        }
        return var2;
    }

    public void serializeToNetwork(PacketDataSerializer var0) {
        var0.writeComponent(this.title);
        var0.writeComponent(this.description);
        var0.writeItem(this.icon);
        var0.writeEnum(this.frame);
        int var1 = 0;
        if (this.background != null) {
            var1 |= 1;
        }
        if (this.showToast) {
            var1 |= 2;
        }
        if (this.hidden) {
            var1 |= 4;
        }
        var0.writeInt(var1);
        if (this.background != null) {
            var0.writeResourceLocation(this.background);
        }
        var0.writeFloat(this.x);
        var0.writeFloat(this.y);
    }

    public static AdvancementDisplay fromNetwork(PacketDataSerializer var0) {
        IChatBaseComponent var1 = var0.readComponent();
        IChatBaseComponent var2 = var0.readComponent();
        ItemStack var3 = var0.readItem();
        AdvancementFrameType var4 = var0.readEnum(AdvancementFrameType.class);
        int var5 = var0.readInt();
        MinecraftKey var6 = (var5 & 1) != 0 ? var0.readResourceLocation() : null;
        boolean var7 = (var5 & 2) != 0;
        boolean var8 = (var5 & 4) != 0;
        AdvancementDisplay var9 = new AdvancementDisplay(var3, var1, var2, var6, var4, var7, false, var8);
        var9.setLocation(var0.readFloat(), var0.readFloat());
        return var9;
    }

    public JsonElement serializeToJson() {
        JsonObject var0 = new JsonObject();
        var0.add("icon", (JsonElement)this.serializeIcon());
        var0.add("title", IChatBaseComponent.ChatSerializer.toJsonTree(this.title));
        var0.add("description", IChatBaseComponent.ChatSerializer.toJsonTree(this.description));
        var0.addProperty("frame", this.frame.getName());
        var0.addProperty("show_toast", Boolean.valueOf(this.showToast));
        var0.addProperty("announce_to_chat", Boolean.valueOf(this.announceChat));
        var0.addProperty("hidden", Boolean.valueOf(this.hidden));
        if (this.background != null) {
            var0.addProperty("background", this.background.toString());
        }
        return var0;
    }

    private JsonObject serializeIcon() {
        JsonObject var0 = new JsonObject();
        var0.addProperty("item", BuiltInRegistries.ITEM.getKey(this.icon.getItem()).toString());
        if (this.icon.hasTag()) {
            var0.addProperty("nbt", this.icon.getTag().toString());
        }
        return var0;
    }
}

