/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimer;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.slf4j.Logger;

public class CustomFunctionCallbackTimerQueue<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CALLBACK_DATA_TAG = "Callback";
    private static final String TIMER_NAME_TAG = "Name";
    private static final String TIMER_TRIGGER_TIME_TAG = "TriggerTime";
    private final CustomFunctionCallbackTimers<T> callbacksRegistry;
    private final Queue<a<T>> queue = new PriorityQueue<a<T>>(CustomFunctionCallbackTimerQueue.createComparator());
    private UnsignedLong sequentialId = UnsignedLong.ZERO;
    private final Table<String, Long, a<T>> events = HashBasedTable.create();

    private static <T> Comparator<a<T>> createComparator() {
        return Comparator.comparingLong(var0 -> var0.triggerTime).thenComparing(var0 -> var0.sequentialId);
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> var02, Stream<? extends Dynamic<?>> var1) {
        this(var02);
        this.queue.clear();
        this.events.clear();
        this.sequentialId = UnsignedLong.ZERO;
        var1.forEach(var0 -> {
            NBTBase var1 = (NBTBase)var0.convert((DynamicOps)DynamicOpsNBT.INSTANCE).getValue();
            if (var1 instanceof NBTTagCompound) {
                NBTTagCompound var2 = (NBTTagCompound)var1;
                this.loadEvent(var2);
            } else {
                LOGGER.warn("Invalid format of events: {}", (Object)var1);
            }
        });
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> var0) {
        this.callbacksRegistry = var0;
    }

    public void tick(T var0, long var1) {
        a<T> var3;
        while ((var3 = this.queue.peek()) != null && var3.triggerTime <= var1) {
            this.queue.remove();
            this.events.remove((Object)var3.id, (Object)var1);
            var3.callback.handle(var0, this, var1);
        }
    }

    public void schedule(String var0, long var1, CustomFunctionCallbackTimer<T> var3) {
        if (this.events.contains((Object)var0, (Object)var1)) {
            return;
        }
        this.sequentialId = this.sequentialId.plus(UnsignedLong.ONE);
        a<T> var4 = new a<T>(var1, this.sequentialId, var0, var3);
        this.events.put((Object)var0, (Object)var1, var4);
        this.queue.add(var4);
    }

    public int remove(String var0) {
        Collection var1 = this.events.row((Object)var0).values();
        var1.forEach(this.queue::remove);
        int var2 = var1.size();
        var1.clear();
        return var2;
    }

    public Set<String> getEventsIds() {
        return Collections.unmodifiableSet(this.events.rowKeySet());
    }

    private void loadEvent(NBTTagCompound var0) {
        NBTTagCompound var1 = var0.getCompound(CALLBACK_DATA_TAG);
        CustomFunctionCallbackTimer<T> var2 = this.callbacksRegistry.deserialize(var1);
        if (var2 != null) {
            String var3 = var0.getString(TIMER_NAME_TAG);
            long var4 = var0.getLong(TIMER_TRIGGER_TIME_TAG);
            this.schedule(var3, var4, var2);
        }
    }

    private NBTTagCompound storeEvent(a<T> var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putString(TIMER_NAME_TAG, var0.id);
        var1.putLong(TIMER_TRIGGER_TIME_TAG, var0.triggerTime);
        var1.put(CALLBACK_DATA_TAG, this.callbacksRegistry.serialize(var0.callback));
        return var1;
    }

    public NBTTagList store() {
        NBTTagList var0 = new NBTTagList();
        this.queue.stream().sorted(CustomFunctionCallbackTimerQueue.createComparator()).map(this::storeEvent).forEach(var0::add);
        return var0;
    }

    public static class a<T> {
        public final long triggerTime;
        public final UnsignedLong sequentialId;
        public final String id;
        public final CustomFunctionCallbackTimer<T> callback;

        a(long var0, UnsignedLong var2, String var3, CustomFunctionCallbackTimer<T> var4) {
            this.triggerTime = var0;
            this.sequentialId = var2;
            this.id = var3;
            this.callback = var4;
        }
    }
}

