/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class StorageNbtProvider
implements NbtProvider {
    final MinecraftKey id;

    StorageNbtProvider(MinecraftKey var0) {
        this.id = var0;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.STORAGE;
    }

    @Override
    @Nullable
    public NBTBase get(LootTableInfo var0) {
        return var0.getLevel().getServer().getCommandStorage().get(this.id);
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of();
    }

    public static class a
    implements LootSerializer<StorageNbtProvider> {
        @Override
        public void serialize(JsonObject var0, StorageNbtProvider var1, JsonSerializationContext var2) {
            var0.addProperty("source", var1.id.toString());
        }

        @Override
        public StorageNbtProvider deserialize(JsonObject var0, JsonDeserializationContext var1) {
            String var2 = ChatDeserializer.getAsString(var0, "source");
            return new StorageNbtProvider(new MinecraftKey(var2));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

