/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionRandomChance
implements LootItemCondition {
    final float probability;

    LootItemConditionRandomChance(float var0) {
        this.probability = var0;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE;
    }

    @Override
    public boolean test(LootTableInfo var0) {
        return var0.getRandom().nextFloat() < this.probability;
    }

    public static LootItemCondition.a randomChance(float var0) {
        return () -> new LootItemConditionRandomChance(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionRandomChance> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionRandomChance var1, JsonSerializationContext var2) {
            var0.addProperty("chance", (Number)Float.valueOf(var1.probability));
        }

        @Override
        public LootItemConditionRandomChance deserialize(JsonObject var0, JsonDeserializationContext var1) {
            return new LootItemConditionRandomChance(ChatDeserializer.getAsFloat(var0, "chance"));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

