/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public class LootItemConditionEntityProperty
implements LootItemCondition {
    final CriterionConditionEntity predicate;
    final LootTableInfo.EntityTarget entityTarget;

    LootItemConditionEntityProperty(CriterionConditionEntity var0, LootTableInfo.EntityTarget var1) {
        this.predicate = var0;
        this.entityTarget = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_PROPERTIES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN, this.entityTarget.getParam());
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(this.entityTarget.getParam());
        Vec3D var2 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        return this.predicate.matches(var0.getLevel(), var2, var1);
    }

    public static LootItemCondition.a entityPresent(LootTableInfo.EntityTarget var0) {
        return LootItemConditionEntityProperty.hasProperties(var0, CriterionConditionEntity.a.entity());
    }

    public static LootItemCondition.a hasProperties(LootTableInfo.EntityTarget var0, CriterionConditionEntity.a var1) {
        return () -> new LootItemConditionEntityProperty(var1.build(), var0);
    }

    public static LootItemCondition.a hasProperties(LootTableInfo.EntityTarget var0, CriterionConditionEntity var1) {
        return () -> new LootItemConditionEntityProperty(var1, var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionEntityProperty> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionEntityProperty var1, JsonSerializationContext var2) {
            var0.add("predicate", var1.predicate.serializeToJson());
            var0.add("entity", var2.serialize((Object)var1.entityTarget));
        }

        @Override
        public LootItemConditionEntityProperty deserialize(JsonObject var0, JsonDeserializationContext var1) {
            CriterionConditionEntity var2 = CriterionConditionEntity.fromJson(var0.get("predicate"));
            return new LootItemConditionEntityProperty(var2, ChatDeserializer.getAsObject(var0, "entity", var1, LootTableInfo.EntityTarget.class));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

