/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class LootItemFunctionCopyNBT
extends LootItemFunctionConditional {
    final NbtProvider source;
    final List<b> operations;

    LootItemFunctionCopyNBT(LootItemCondition[] var0, NbtProvider var1, List<b> var2) {
        super(var0);
        this.source = var1;
        this.operations = ImmutableList.copyOf(var2);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_NBT;
    }

    static ArgumentNBTKey.g compileNbtPath(String var0) {
        try {
            return new ArgumentNBTKey().parse(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            throw new IllegalArgumentException("Failed to parse path " + var0, var1);
        }
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTBase var22 = this.source.get(var1);
        if (var22 != null) {
            this.operations.forEach(var2 -> var2.apply(var0::getOrCreateTag, var22));
        }
        return var0;
    }

    public static a copyData(NbtProvider var0) {
        return new a(var0);
    }

    public static a copyData(LootTableInfo.EntityTarget var0) {
        return new a(ContextNbtProvider.forContextEntity(var0));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NbtProvider source;
        private final List<b> ops = Lists.newArrayList();

        a(NbtProvider var0) {
            this.source = var0;
        }

        public a copy(String var0, String var1, Action var2) {
            this.ops.add(new b(var0, var1, var2));
            return this;
        }

        public a copy(String var0, String var1) {
            return this.copy(var0, var1, Action.REPLACE);
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionCopyNBT(this.getConditions(), this.source, this.ops);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    static class b {
        private final String sourcePathText;
        private final ArgumentNBTKey.g sourcePath;
        private final String targetPathText;
        private final ArgumentNBTKey.g targetPath;
        private final Action op;

        b(String var0, String var1, Action var2) {
            this.sourcePathText = var0;
            this.sourcePath = LootItemFunctionCopyNBT.compileNbtPath(var0);
            this.targetPathText = var1;
            this.targetPath = LootItemFunctionCopyNBT.compileNbtPath(var1);
            this.op = var2;
        }

        public void apply(Supplier<NBTBase> var0, NBTBase var1) {
            try {
                List<NBTBase> var2 = this.sourcePath.get(var1);
                if (!var2.isEmpty()) {
                    this.op.merge(var0.get(), this.targetPath, var2);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        public JsonObject toJson() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("source", this.sourcePathText);
            var0.addProperty("target", this.targetPathText);
            var0.addProperty("op", this.op.name);
            return var0;
        }

        public static b fromJson(JsonObject var0) {
            String var1 = ChatDeserializer.getAsString(var0, "source");
            String var2 = ChatDeserializer.getAsString(var0, "target");
            Action var3 = Action.getByName(ChatDeserializer.getAsString(var0, "op"));
            return new b(var1, var2, var3);
        }
    }

    public static class d
    extends LootItemFunctionConditional.c<LootItemFunctionCopyNBT> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionCopyNBT var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("source", var2.serialize((Object)var1.source));
            JsonArray var3 = new JsonArray();
            var1.operations.stream().map(b::toJson).forEach(arg_0 -> ((JsonArray)var3).add(arg_0));
            var0.add("ops", (JsonElement)var3);
        }

        @Override
        public LootItemFunctionCopyNBT deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            NbtProvider var3 = ChatDeserializer.getAsObject(var0, "source", var1, NbtProvider.class);
            ArrayList var4 = Lists.newArrayList();
            JsonArray var5 = ChatDeserializer.getAsJsonArray(var0, "ops");
            for (JsonElement var7 : var5) {
                JsonObject var8 = ChatDeserializer.convertToJsonObject(var7, "op");
                var4.add(b.fromJson(var8));
            }
            return new LootItemFunctionCopyNBT(var2, var3, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action REPLACE = new Action("replace"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                var1.set(var0, (NBTBase)Iterables.getLast(var2));
            }
        };
        public static final /* enum */ Action APPEND = new Action("append"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagList::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagList) {
                        var2.forEach(var1 -> ((NBTTagList)var12).add(var1.copy()));
                    }
                });
            }
        };
        public static final /* enum */ Action MERGE = new Action("merge"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagCompound::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagCompound) {
                        var2.forEach(var1 -> {
                            if (var1 instanceof NBTTagCompound) {
                                ((NBTTagCompound)var12).merge((NBTTagCompound)var1);
                            }
                        });
                    }
                });
            }
        };
        final String name;
        private static final /* synthetic */ Action[] e;

        public static Action[] values() {
            return (Action[])e.clone();
        }

        public static Action valueOf(String var0) {
            return Enum.valueOf(Action.class, var0);
        }

        public abstract void merge(NBTBase var1, ArgumentNBTKey.g var2, List<NBTBase> var3) throws CommandSyntaxException;

        Action(String var2) {
            this.name = var2;
        }

        public static Action getByName(String var0) {
            for (Action var4 : Action.values()) {
                if (!var4.name.equals(var0)) continue;
                return var4;
            }
            throw new IllegalArgumentException("Invalid merge strategy" + var0);
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{REPLACE, APPEND, MERGE};
        }

        static {
            e = Action.a();
        }
    }
}

