/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootSelectorLootTable
extends LootSelectorEntry {
    final MinecraftKey name;

    LootSelectorLootTable(MinecraftKey var0, int var1, int var2, LootItemCondition[] var3, LootItemFunction[] var4) {
        super(var1, var2, var3, var4);
        this.name = var0;
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.REFERENCE;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
        LootTable var2 = var1.getLootTable(this.name);
        var2.getRandomItemsRaw(var1, var0);
    }

    @Override
    public void validate(LootCollector var0) {
        if (var0.hasVisitedTable(this.name)) {
            var0.reportProblem("Table " + this.name + " is recursively called");
            return;
        }
        super.validate(var0);
        LootTable var1 = var0.resolveLootTable(this.name);
        if (var1 == null) {
            var0.reportProblem("Unknown loot table called " + this.name);
        } else {
            var1.validate(var0.enterTable("->{" + this.name + "}", this.name));
        }
    }

    public static LootSelectorEntry.a<?> lootTableReference(MinecraftKey var0) {
        return LootSelectorLootTable.simpleBuilder((var1, var2, var3, var4) -> new LootSelectorLootTable(var0, var1, var2, var3, var4));
    }

    public static class a
    extends LootSelectorEntry.e<LootSelectorLootTable> {
        @Override
        public void serializeCustom(JsonObject var0, LootSelectorLootTable var1, JsonSerializationContext var2) {
            super.serializeCustom(var0, var1, var2);
            var0.addProperty("name", var1.name.toString());
        }

        @Override
        protected LootSelectorLootTable deserialize(JsonObject var0, JsonDeserializationContext var1, int var2, int var3, LootItemCondition[] var4, LootItemFunction[] var5) {
            MinecraftKey var6 = new MinecraftKey(ChatDeserializer.getAsString(var0, "name"));
            return new LootSelectorLootTable(var6, var2, var3, var4, var5);
        }

        @Override
        protected /* synthetic */ LootSelectorEntry deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n2, int n3, LootItemCondition[] lootItemConditionArray, LootItemFunction[] lootItemFunctionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, n2, n3, lootItemConditionArray, lootItemFunctionArray);
        }
    }
}

