/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSelector {
    final LootEntryAbstract[] entries;
    final LootItemCondition[] conditions;
    private final Predicate<LootTableInfo> compositeCondition;
    final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;
    final NumberProvider rolls;
    final NumberProvider bonusRolls;

    LootSelector(LootEntryAbstract[] var0, LootItemCondition[] var1, LootItemFunction[] var2, NumberProvider var3, NumberProvider var4) {
        this.entries = var0;
        this.conditions = var1;
        this.compositeCondition = LootItemConditions.andConditions(var1);
        this.functions = var2;
        this.compositeFunction = LootItemFunctions.compose(var2);
        this.rolls = var3;
        this.bonusRolls = var4;
    }

    private void addRandomItem(Consumer<ItemStack> var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        ArrayList var32 = Lists.newArrayList();
        MutableInt var4 = new MutableInt();
        for (LootEntryAbstract lootEntryAbstract : this.entries) {
            lootEntryAbstract.expand(var1, var3 -> {
                int var4 = var3.getWeight(var1.getLuck());
                if (var4 > 0) {
                    var32.add(var3);
                    var4.add(var4);
                }
            });
        }
        int var5 = var32.size();
        if (var4.intValue() == 0 || var5 == 0) {
            return;
        }
        if (var5 == 1) {
            ((LootEntry)var32.get(0)).createItemStack(var0, var1);
            return;
        }
        int var6 = var2.nextInt(var4.intValue());
        for (LootEntry lootEntry : var32) {
            if ((var6 -= lootEntry.getWeight(var1.getLuck())) >= 0) continue;
            lootEntry.createItemStack(var0, var1);
            return;
        }
    }

    public void addRandomItems(Consumer<ItemStack> var0, LootTableInfo var1) {
        if (!this.compositeCondition.test(var1)) {
            return;
        }
        Consumer<ItemStack> var2 = LootItemFunction.decorate(this.compositeFunction, var0, var1);
        int var3 = this.rolls.getInt(var1) + MathHelper.floor(this.bonusRolls.getFloat(var1) * var1.getLuck());
        for (int var4 = 0; var4 < var3; ++var4) {
            this.addRandomItem(var2, var1);
        }
    }

    public void validate(LootCollector var0) {
        int var1;
        for (var1 = 0; var1 < this.conditions.length; ++var1) {
            this.conditions[var1].validate(var0.forChild(".condition[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.functions.length; ++var1) {
            this.functions[var1].validate(var0.forChild(".functions[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.entries.length; ++var1) {
            this.entries[var1].validate(var0.forChild(".entries[" + var1 + "]"));
        }
        this.rolls.validate(var0.forChild(".rolls"));
        this.bonusRolls.validate(var0.forChild(".bonusRolls"));
    }

    public static a lootPool() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a>,
    LootItemConditionUser<a> {
        private final List<LootEntryAbstract> entries = Lists.newArrayList();
        private final List<LootItemCondition> conditions = Lists.newArrayList();
        private final List<LootItemFunction> functions = Lists.newArrayList();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);

        public a setRolls(NumberProvider var0) {
            this.rolls = var0;
            return this;
        }

        @Override
        public a unwrap() {
            return this;
        }

        public a setBonusRolls(NumberProvider var0) {
            this.bonusRolls = var0;
            return this;
        }

        public a add(LootEntryAbstract.a<?> var0) {
            this.entries.add(var0.build());
            return this;
        }

        @Override
        public a when(LootItemCondition.a var0) {
            this.conditions.add(var0.build());
            return this;
        }

        @Override
        public a apply(LootItemFunction.a var0) {
            this.functions.add(var0.build());
            return this;
        }

        public LootSelector build() {
            if (this.rolls == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootSelector(this.entries.toArray(new LootEntryAbstract[0]), this.conditions.toArray(new LootItemCondition[0]), this.functions.toArray(new LootItemFunction[0]), this.rolls, this.bonusRolls);
        }

        @Override
        public /* synthetic */ LootItemFunctionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }

        @Override
        public /* synthetic */ LootItemConditionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemConditionUser when(LootItemCondition.a a2) {
            return this.when(a2);
        }
    }

    public static class b
    implements JsonDeserializer<LootSelector>,
    JsonSerializer<LootSelector> {
        public LootSelector deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "loot pool");
            LootEntryAbstract[] var4 = ChatDeserializer.getAsObject(var3, "entries", var2, LootEntryAbstract[].class);
            LootItemCondition[] var5 = ChatDeserializer.getAsObject(var3, "conditions", new LootItemCondition[0], var2, LootItemCondition[].class);
            LootItemFunction[] var6 = ChatDeserializer.getAsObject(var3, "functions", new LootItemFunction[0], var2, LootItemFunction[].class);
            NumberProvider var7 = ChatDeserializer.getAsObject(var3, "rolls", var2, NumberProvider.class);
            NumberProvider var8 = ChatDeserializer.getAsObject(var3, "bonus_rolls", ConstantValue.exactly(0.0f), var2, NumberProvider.class);
            return new LootSelector(var4, var5, var6, var7, var8);
        }

        public JsonElement serialize(LootSelector var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            var3.add("rolls", var2.serialize((Object)var0.rolls));
            var3.add("bonus_rolls", var2.serialize((Object)var0.bonusRolls));
            var3.add("entries", var2.serialize((Object)var0.entries));
            if (!ArrayUtils.isEmpty((Object[])var0.conditions)) {
                var3.add("conditions", var2.serialize((Object)var0.conditions));
            }
            if (!ArrayUtils.isEmpty((Object[])var0.functions)) {
                var3.add("functions", var2.serialize((Object)var0.functions));
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootSelector)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

