/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.MaterialMapColor;

public final class Material {
    public static final Material AIR = new a(MaterialMapColor.NONE).noCollider().notSolidBlocking().nonSolid().replaceable().build();
    public static final Material STRUCTURAL_AIR = new a(MaterialMapColor.NONE).noCollider().notSolidBlocking().nonSolid().replaceable().build();
    public static final Material PORTAL = new a(MaterialMapColor.NONE).noCollider().notSolidBlocking().nonSolid().notPushable().build();
    public static final Material CLOTH_DECORATION = new a(MaterialMapColor.WOOL).noCollider().notSolidBlocking().nonSolid().flammable().build();
    public static final Material PLANT = new a(MaterialMapColor.PLANT).noCollider().notSolidBlocking().nonSolid().destroyOnPush().build();
    public static final Material WATER_PLANT = new a(MaterialMapColor.WATER).noCollider().notSolidBlocking().nonSolid().destroyOnPush().build();
    public static final Material REPLACEABLE_PLANT = new a(MaterialMapColor.PLANT).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().flammable().build();
    public static final Material REPLACEABLE_FIREPROOF_PLANT = new a(MaterialMapColor.PLANT).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().build();
    public static final Material REPLACEABLE_WATER_PLANT = new a(MaterialMapColor.WATER).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().build();
    public static final Material WATER = new a(MaterialMapColor.WATER).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().liquid().build();
    public static final Material BUBBLE_COLUMN = new a(MaterialMapColor.WATER).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().liquid().build();
    public static final Material LAVA = new a(MaterialMapColor.FIRE).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().liquid().build();
    public static final Material TOP_SNOW = new a(MaterialMapColor.SNOW).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().build();
    public static final Material FIRE = new a(MaterialMapColor.NONE).noCollider().notSolidBlocking().nonSolid().destroyOnPush().replaceable().build();
    public static final Material DECORATION = new a(MaterialMapColor.NONE).noCollider().notSolidBlocking().nonSolid().destroyOnPush().build();
    public static final Material WEB = new a(MaterialMapColor.WOOL).noCollider().notSolidBlocking().destroyOnPush().build();
    public static final Material SCULK = new a(MaterialMapColor.COLOR_BLACK).build();
    public static final Material BUILDABLE_GLASS = new a(MaterialMapColor.NONE).build();
    public static final Material CLAY = new a(MaterialMapColor.CLAY).build();
    public static final Material DIRT = new a(MaterialMapColor.DIRT).build();
    public static final Material GRASS = new a(MaterialMapColor.GRASS).build();
    public static final Material ICE_SOLID = new a(MaterialMapColor.ICE).build();
    public static final Material SAND = new a(MaterialMapColor.SAND).build();
    public static final Material SPONGE = new a(MaterialMapColor.COLOR_YELLOW).build();
    public static final Material SHULKER_SHELL = new a(MaterialMapColor.COLOR_PURPLE).build();
    public static final Material WOOD = new a(MaterialMapColor.WOOD).flammable().build();
    public static final Material NETHER_WOOD = new a(MaterialMapColor.WOOD).build();
    public static final Material BAMBOO_SAPLING = new a(MaterialMapColor.WOOD).flammable().destroyOnPush().noCollider().build();
    public static final Material BAMBOO = new a(MaterialMapColor.WOOD).flammable().destroyOnPush().build();
    public static final Material WOOL = new a(MaterialMapColor.WOOL).flammable().build();
    public static final Material EXPLOSIVE = new a(MaterialMapColor.FIRE).flammable().notSolidBlocking().build();
    public static final Material LEAVES = new a(MaterialMapColor.PLANT).flammable().notSolidBlocking().destroyOnPush().build();
    public static final Material GLASS = new a(MaterialMapColor.NONE).notSolidBlocking().build();
    public static final Material ICE = new a(MaterialMapColor.ICE).notSolidBlocking().build();
    public static final Material CACTUS = new a(MaterialMapColor.PLANT).notSolidBlocking().destroyOnPush().build();
    public static final Material STONE = new a(MaterialMapColor.STONE).build();
    public static final Material METAL = new a(MaterialMapColor.METAL).build();
    public static final Material SNOW = new a(MaterialMapColor.SNOW).build();
    public static final Material HEAVY_METAL = new a(MaterialMapColor.METAL).notPushable().build();
    public static final Material BARRIER = new a(MaterialMapColor.NONE).notPushable().build();
    public static final Material PISTON = new a(MaterialMapColor.STONE).notPushable().build();
    public static final Material MOSS = new a(MaterialMapColor.PLANT).destroyOnPush().build();
    public static final Material VEGETABLE = new a(MaterialMapColor.PLANT).destroyOnPush().build();
    public static final Material EGG = new a(MaterialMapColor.PLANT).destroyOnPush().build();
    public static final Material CAKE = new a(MaterialMapColor.NONE).destroyOnPush().build();
    public static final Material AMETHYST = new a(MaterialMapColor.COLOR_PURPLE).build();
    public static final Material POWDER_SNOW = new a(MaterialMapColor.SNOW).nonSolid().noCollider().build();
    public static final Material FROGSPAWN = new a(MaterialMapColor.WATER).noCollider().notSolidBlocking().nonSolid().destroyOnPush().build();
    public static final Material FROGLIGHT = new a(MaterialMapColor.NONE).build();
    public static final Material DECORATED_POT = new a(MaterialMapColor.TERRACOTTA_RED).destroyOnPush().build();
    private final MaterialMapColor color;
    private final EnumPistonReaction pushReaction;
    private final boolean blocksMotion;
    private final boolean flammable;
    private final boolean liquid;
    private final boolean solidBlocking;
    private final boolean replaceable;
    private final boolean solid;

    public Material(MaterialMapColor var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, EnumPistonReaction var7) {
        this.color = var0;
        this.liquid = var1;
        this.solid = var2;
        this.blocksMotion = var3;
        this.solidBlocking = var4;
        this.flammable = var5;
        this.replaceable = var6;
        this.pushReaction = var7;
    }

    public boolean isLiquid() {
        return this.liquid;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean blocksMotion() {
        return this.blocksMotion;
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public boolean isSolidBlocking() {
        return this.solidBlocking;
    }

    public EnumPistonReaction getPushReaction() {
        return this.pushReaction;
    }

    public MaterialMapColor getColor() {
        return this.color;
    }

    public static class a {
        private EnumPistonReaction pushReaction = EnumPistonReaction.NORMAL;
        private boolean blocksMotion = true;
        private boolean flammable;
        private boolean liquid;
        private boolean replaceable;
        private boolean solid = true;
        private final MaterialMapColor color;
        private boolean solidBlocking = true;

        public a(MaterialMapColor var0) {
            this.color = var0;
        }

        public a liquid() {
            this.liquid = true;
            return this;
        }

        public a nonSolid() {
            this.solid = false;
            return this;
        }

        public a noCollider() {
            this.blocksMotion = false;
            return this;
        }

        a notSolidBlocking() {
            this.solidBlocking = false;
            return this;
        }

        protected a flammable() {
            this.flammable = true;
            return this;
        }

        public a replaceable() {
            this.replaceable = true;
            return this;
        }

        protected a destroyOnPush() {
            this.pushReaction = EnumPistonReaction.DESTROY;
            return this;
        }

        protected a notPushable() {
            this.pushReaction = EnumPistonReaction.BLOCK;
            return this;
        }

        public Material build() {
            return new Material(this.color, this.liquid, this.solid, this.blocksMotion, this.solidBlocking, this.flammable, this.replaceable, this.pushReaction);
        }
    }
}

