/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class FluidTypeFlowing
extends FluidType {
    public static final BlockStateBoolean FALLING = BlockProperties.FALLING;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.a>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.a> var0 = new Object2ByteLinkedOpenHashMap<Block.a>(200){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue((byte)127);
        return var0;
    });
    private final Map<Fluid, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> var0) {
        var0.add(FALLING);
    }

    @Override
    public Vec3D getFlow(IBlockAccess var0, BlockPosition var1, Fluid var2) {
        double var3 = 0.0;
        double var5 = 0.0;
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var7.setWithOffset((BaseBlockPosition)var1, var9);
            Object var10 = var0.getFluidState(var7);
            if (!this.affectsFlow((Fluid)var10)) continue;
            float var11 = ((Fluid)var10).getOwnHeight();
            float var12 = 0.0f;
            if (var11 == 0.0f) {
                BaseBlockPosition var13;
                Fluid var14;
                if (!var0.getBlockState(var7).getMaterial().blocksMotion() && this.affectsFlow(var14 = var0.getFluidState((BlockPosition)(var13 = var7.below()))) && (var11 = var14.getOwnHeight()) > 0.0f) {
                    var12 = var2.getOwnHeight() - (var11 - 0.8888889f);
                }
            } else if (var11 > 0.0f) {
                var12 = var2.getOwnHeight() - var11;
            }
            if (var12 == 0.0f) continue;
            var3 += (double)((float)var9.getStepX() * var12);
            var5 += (double)((float)var9.getStepZ() * var12);
        }
        Vec3D var8 = new Vec3D(var3, 0.0, var5);
        if (var2.getValue(FALLING).booleanValue()) {
            for (Object var10 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                var7.setWithOffset((BaseBlockPosition)var1, (EnumDirection)var10);
                if (!this.isSolidFace(var0, var7, (EnumDirection)var10) && !this.isSolidFace(var0, (BlockPosition)var7.above(), (EnumDirection)var10)) continue;
                var8 = var8.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return var8.normalize();
    }

    private boolean affectsFlow(Fluid var0) {
        return var0.isEmpty() || var0.getType().isSame(this);
    }

    protected boolean isSolidFace(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        Fluid var4 = var0.getFluidState(var1);
        if (var4.getType().isSame(this)) {
            return false;
        }
        if (var2 == EnumDirection.UP) {
            return true;
        }
        if (var3.getMaterial() == Material.ICE) {
            return false;
        }
        return var3.isFaceSturdy(var0, var1, var2);
    }

    protected void spread(World var0, BlockPosition var1, Fluid var2) {
        if (var2.isEmpty()) {
            return;
        }
        IBlockData var3 = var0.getBlockState(var1);
        BlockPosition var4 = var1.below();
        IBlockData var5 = var0.getBlockState(var4);
        Fluid var6 = this.getNewLiquid(var0, var4, var5);
        if (this.canSpreadTo(var0, var1, var3, EnumDirection.DOWN, var4, var5, var0.getFluidState(var4), var6.getType())) {
            this.spreadTo(var0, var4, var5, EnumDirection.DOWN, var6);
            if (this.sourceNeighborCount(var0, var1) >= 3) {
                this.spreadToSides(var0, var1, var2, var3);
            }
        } else if (var2.isSource() || !this.isWaterHole(var0, var6.getType(), var1, var3, var4, var5)) {
            this.spreadToSides(var0, var1, var2, var3);
        }
    }

    private void spreadToSides(World var0, BlockPosition var1, Fluid var2, IBlockData var3) {
        int var4 = var2.getAmount() - this.getDropOff(var0);
        if (var2.getValue(FALLING).booleanValue()) {
            var4 = 7;
        }
        if (var4 <= 0) {
            return;
        }
        Map<EnumDirection, Fluid> var5 = this.getSpread(var0, var1, var3);
        for (Map.Entry<EnumDirection, Fluid> var7 : var5.entrySet()) {
            IBlockData var11;
            EnumDirection var8 = var7.getKey();
            Fluid var9 = var7.getValue();
            BlockPosition var10 = var1.relative(var8);
            if (!this.canSpreadTo(var0, var1, var3, var8, var10, var11 = var0.getBlockState(var10), var0.getFluidState(var10), var9.getType())) continue;
            this.spreadTo(var0, var10, var11, var8, var9);
        }
    }

    protected Fluid getNewLiquid(World var0, BlockPosition var1, IBlockData var2) {
        Object var5;
        Object var7;
        Object var62;
        int var3 = 0;
        int var4 = 0;
        for (Object var62 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var7 = var1.relative((EnumDirection)var62);
            IBlockData var8 = var0.getBlockState((BlockPosition)var7);
            Fluid var9 = var8.getFluidState();
            if (!var9.getType().isSame(this) || !this.canPassThroughWall((EnumDirection)var62, var0, var1, var2, (BlockPosition)var7, var8)) continue;
            if (var9.isSource()) {
                ++var4;
            }
            var3 = Math.max(var3, var9.getAmount());
        }
        if (this.canConvertToSource(var0) && var4 >= 2) {
            var5 = var0.getBlockState(var1.below());
            var62 = ((BlockBase.BlockData)var5).getFluidState();
            if (((BlockBase.BlockData)var5).getMaterial().isSolid() || this.isSourceBlockOfThisType((Fluid)var62)) {
                return this.getSource(false);
            }
        }
        if (!((Fluid)(var7 = ((BlockBase.BlockData)(var62 = var0.getBlockState((BlockPosition)(var5 = var1.above())))).getFluidState())).isEmpty() && ((Fluid)var7).getType().isSame(this) && this.canPassThroughWall(EnumDirection.UP, var0, var1, var2, (BlockPosition)var5, (IBlockData)var62)) {
            return this.getFlowing(8, true);
        }
        int var8 = var3 - this.getDropOff(var0);
        if (var8 <= 0) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        return this.getFlowing(var8, false);
    }

    private boolean canPassThroughWall(EnumDirection var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5) {
        VoxelShape var9;
        VoxelShape var8;
        boolean var10;
        Block.a var7;
        Object2ByteLinkedOpenHashMap<Block.a> var6 = var3.getBlock().hasDynamicShape() || var5.getBlock().hasDynamicShape() ? null : OCCLUSION_CACHE.get();
        if (var6 != null) {
            var7 = new Block.a(var3, var5, var0);
            byte var82 = var6.getAndMoveToFirst((Object)var7);
            if (var82 != 127) {
                return var82 != 0;
            }
        } else {
            var7 = null;
        }
        boolean bl = var10 = !VoxelShapes.mergedFaceOccludes(var8 = var3.getCollisionShape(var1, var2), var9 = var5.getCollisionShape(var1, var4), var0);
        if (var6 != null) {
            if (var6.size() == 200) {
                var6.removeLastByte();
            }
            var6.putAndMoveToFirst((Object)var7, (byte)(var10 ? 1 : 0));
        }
        return var10;
    }

    public abstract FluidType getFlowing();

    public Fluid getFlowing(int var0, boolean var1) {
        return (Fluid)((Fluid)this.getFlowing().defaultFluidState().setValue(LEVEL, var0)).setValue(FALLING, var1);
    }

    public abstract FluidType getSource();

    public Fluid getSource(boolean var0) {
        return (Fluid)this.getSource().defaultFluidState().setValue(FALLING, var0);
    }

    protected abstract boolean canConvertToSource(World var1);

    protected void spreadTo(GeneratorAccess var0, BlockPosition var1, IBlockData var2, EnumDirection var3, Fluid var4) {
        if (var2.getBlock() instanceof IFluidContainer) {
            ((IFluidContainer)((Object)var2.getBlock())).placeLiquid(var0, var1, var2, var4);
        } else {
            if (!var2.isAir()) {
                this.beforeDestroyingBlock(var0, var1, var2);
            }
            var0.setBlock(var1, var4.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(GeneratorAccess var1, BlockPosition var2, IBlockData var3);

    private static short getCacheKey(BlockPosition var0, BlockPosition var1) {
        int var2 = var1.getX() - var0.getX();
        int var3 = var1.getZ() - var0.getZ();
        return (short)((var2 + 128 & 0xFF) << 8 | var3 + 128 & 0xFF);
    }

    protected int getSlopeDistance(IWorldReader var0, BlockPosition var1, int var22, EnumDirection var32, IBlockData var4, BlockPosition var5, Short2ObjectMap<Pair<IBlockData, Fluid>> var6, Short2BooleanMap var7) {
        int var8 = 1000;
        for (EnumDirection var10 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            int var17;
            if (var10 == var32) continue;
            BlockPosition var11 = var1.relative(var10);
            short var12 = FluidTypeFlowing.getCacheKey(var5, var11);
            Pair var13 = (Pair)var6.computeIfAbsent(var12, var2 -> {
                IBlockData var3 = var0.getBlockState(var11);
                return Pair.of((Object)var3, (Object)var3.getFluidState());
            });
            IBlockData var14 = (IBlockData)var13.getFirst();
            Fluid var15 = (Fluid)var13.getSecond();
            if (!this.canPassThrough(var0, this.getFlowing(), var1, var4, var10, var11, var14, var15)) continue;
            boolean var16 = var7.computeIfAbsent(var12, var3 -> {
                BlockPosition var4 = var11.below();
                IBlockData var5 = var0.getBlockState(var4);
                return this.isWaterHole(var0, this.getFlowing(), var11, var14, var4, var5);
            });
            if (var16) {
                return var22;
            }
            if (var22 >= this.getSlopeFindDistance(var0) || (var17 = this.getSlopeDistance(var0, var11, var22 + 1, var10.getOpposite(), var14, var5, var6, var7)) >= var8) continue;
            var8 = var17;
        }
        return var8;
    }

    private boolean isWaterHole(IBlockAccess var0, FluidType var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5) {
        if (!this.canPassThroughWall(EnumDirection.DOWN, var0, var2, var3, var4, var5)) {
            return false;
        }
        if (var5.getFluidState().getType().isSame(this)) {
            return true;
        }
        return this.canHoldFluid(var0, var4, var5, var1);
    }

    private boolean canPassThrough(IBlockAccess var0, FluidType var1, BlockPosition var2, IBlockData var3, EnumDirection var4, BlockPosition var5, IBlockData var6, Fluid var7) {
        return !this.isSourceBlockOfThisType(var7) && this.canPassThroughWall(var4, var0, var2, var3, var5, var6) && this.canHoldFluid(var0, var5, var6, var1);
    }

    private boolean isSourceBlockOfThisType(Fluid var0) {
        return var0.getType().isSame(this) && var0.isSource();
    }

    protected abstract int getSlopeFindDistance(IWorldReader var1);

    private int sourceNeighborCount(IWorldReader var0, BlockPosition var1) {
        int var2 = 0;
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var5 = var1.relative(var4);
            Fluid var6 = var0.getFluidState(var5);
            if (!this.isSourceBlockOfThisType(var6)) continue;
            ++var2;
        }
        return var2;
    }

    protected Map<EnumDirection, Fluid> getSpread(World var0, BlockPosition var1, IBlockData var22) {
        int var3 = 1000;
        EnumMap var42 = Maps.newEnumMap(EnumDirection.class);
        Short2ObjectOpenHashMap var5 = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap var6 = new Short2BooleanOpenHashMap();
        for (EnumDirection var8 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var9 = var1.relative(var8);
            short var10 = FluidTypeFlowing.getCacheKey(var1, var9);
            Pair var11 = (Pair)var5.computeIfAbsent(var10, var2 -> {
                IBlockData var3 = var0.getBlockState(var9);
                return Pair.of((Object)var3, (Object)var3.getFluidState());
            });
            IBlockData var12 = (IBlockData)var11.getFirst();
            Fluid var13 = (Fluid)var11.getSecond();
            Fluid var14 = this.getNewLiquid(var0, var9, var12);
            if (!this.canPassThrough(var0, var14.getType(), var1, var22, var8, var9, var12, var13)) continue;
            BlockPosition var16 = var9.below();
            boolean var17 = var6.computeIfAbsent(var10, var4 -> {
                IBlockData var5 = var0.getBlockState(var16);
                return this.isWaterHole(var0, this.getFlowing(), var9, var12, var16, var5);
            });
            int var15 = var17 ? 0 : this.getSlopeDistance(var0, var9, 1, var8.getOpposite(), var12, var1, (Short2ObjectMap<Pair<IBlockData, Fluid>>)var5, (Short2BooleanMap)var6);
            if (var15 < var3) {
                var42.clear();
            }
            if (var15 > var3) continue;
            var42.put(var8, var14);
            var3 = var15;
        }
        return var42;
    }

    private boolean canHoldFluid(IBlockAccess var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        Block var4 = var2.getBlock();
        if (var4 instanceof IFluidContainer) {
            return ((IFluidContainer)((Object)var4)).canPlaceLiquid(var0, var1, var2, var3);
        }
        if (var4 instanceof BlockDoor || var2.is(TagsBlock.SIGNS) || var2.is(Blocks.LADDER) || var2.is(Blocks.SUGAR_CANE) || var2.is(Blocks.BUBBLE_COLUMN)) {
            return false;
        }
        Material var5 = var2.getMaterial();
        if (var5 == Material.PORTAL || var5 == Material.STRUCTURAL_AIR || var5 == Material.WATER_PLANT || var5 == Material.REPLACEABLE_WATER_PLANT) {
            return false;
        }
        return !var5.blocksMotion();
    }

    protected boolean canSpreadTo(IBlockAccess var0, BlockPosition var1, IBlockData var2, EnumDirection var3, BlockPosition var4, IBlockData var5, Fluid var6, FluidType var7) {
        return var6.canBeReplacedWith(var0, var4, var7, var3) && this.canPassThroughWall(var3, var0, var1, var2, var4, var5) && this.canHoldFluid(var0, var4, var5, var7);
    }

    protected abstract int getDropOff(IWorldReader var1);

    protected int getSpreadDelay(World var0, BlockPosition var1, Fluid var2, Fluid var3) {
        return this.getTickDelay(var0);
    }

    @Override
    public void tick(World var0, BlockPosition var1, Fluid var2) {
        if (!var2.isSource()) {
            Fluid var3 = this.getNewLiquid(var0, var1, var0.getBlockState(var1));
            int var4 = this.getSpreadDelay(var0, var1, var2, var3);
            if (var3.isEmpty()) {
                var2 = var3;
                var0.setBlock(var1, Blocks.AIR.defaultBlockState(), 3);
            } else if (!var3.equals(var2)) {
                var2 = var3;
                IBlockData var5 = var2.createLegacyBlock();
                var0.setBlock(var1, var5, 2);
                var0.scheduleTick(var1, var2.getType(), var4);
                var0.updateNeighborsAt(var1, var5.getBlock());
            }
        }
        this.spread(var0, var1, var2);
    }

    protected static int getLegacyLevel(Fluid var0) {
        if (var0.isSource()) {
            return 0;
        }
        return 8 - Math.min(var0.getAmount(), 8) + (var0.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(Fluid var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getType().isSame(var1.getFluidState(var2.above()).getType());
    }

    @Override
    public float getHeight(Fluid var0, IBlockAccess var1, BlockPosition var2) {
        if (FluidTypeFlowing.hasSameAbove(var0, var1, var2)) {
            return 1.0f;
        }
        return var0.getOwnHeight();
    }

    @Override
    public float getOwnHeight(Fluid var0) {
        return (float)var0.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(Fluid var1);

    @Override
    public VoxelShape getShape(Fluid var0, IBlockAccess var1, BlockPosition var22) {
        if (var0.getAmount() == 9 && FluidTypeFlowing.hasSameAbove(var0, var1, var22)) {
            return VoxelShapes.block();
        }
        return this.shapes.computeIfAbsent(var0, var2 -> VoxelShapes.box(0.0, 0.0, 0.0, 1.0, var2.getHeight(var1, var22), 1.0));
    }
}

