/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilPieces;

public class NetherFossilStructure
extends Structure {
    public static final Codec<NetherFossilStructure> CODEC = RecordCodecBuilder.create(var02 -> var02.group(NetherFossilStructure.settingsCodec(var02), (App)HeightProvider.CODEC.fieldOf("height").forGetter(var0 -> var0.height)).apply((Applicative)var02, NetherFossilStructure::new));
    public final HeightProvider height;

    public NetherFossilStructure(Structure.c var0, HeightProvider var1) {
        super(var0);
        this.height = var1;
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        Object var9;
        SeededRandom var1 = var0.random();
        int var2 = var0.chunkPos().getMinBlockX() + var1.nextInt(16);
        int var3 = var0.chunkPos().getMinBlockZ() + var1.nextInt(16);
        int var4 = var0.chunkGenerator().getSeaLevel();
        WorldGenerationContext var5 = new WorldGenerationContext(var0.chunkGenerator(), var0.heightAccessor());
        int var6 = this.height.sample(var1, var5);
        BlockColumn var7 = var0.chunkGenerator().getBaseColumn(var2, var3, var0.heightAccessor(), var0.randomState());
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition(var2, var6, var3);
        while (var6 > var4) {
            var9 = var7.getBlock(var6);
            IBlockData var10 = var7.getBlock(--var6);
            if (!((BlockBase.BlockData)var9).isAir() || !var10.is(Blocks.SOUL_SAND) && !var10.isFaceSturdy(BlockAccessAir.INSTANCE, var8.setY(var6), EnumDirection.UP)) continue;
            break;
        }
        if (var6 <= var4) {
            return Optional.empty();
        }
        var9 = new BlockPosition(var2, var6, var3);
        return Optional.of(new Structure.b((BlockPosition)var9, arg_0 -> NetherFossilStructure.a(var0, var1, (BlockPosition)var9, arg_0)));
    }

    @Override
    public StructureType<?> type() {
        return StructureType.NETHER_FOSSIL;
    }

    private static /* synthetic */ void a(Structure.a var0, SeededRandom var1, BlockPosition var2, StructurePiecesBuilder var3) {
        NetherFossilPieces.addPieces(var0.structureTemplateManager(), var3, var1, var2);
    }
}

