/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.data.loot.packs.UpdateOneTwentyBuiltInLootTables;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final Codec<DesertPyramidStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c var0) {
        super(DesertPyramidPiece::new, 21, 21, var0);
    }

    @Override
    public void afterPlace(GeneratorAccessSeed var0, StructureManager var12, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, PiecesContainer var6) {
        if (!var0.enabledFeatures().contains(FeatureFlags.UPDATE_1_20)) {
            return;
        }
        ArraySetSorted var7 = ArraySetSorted.create(BaseBlockPosition::compareTo);
        for (StructurePiece var9 : var6.pieces()) {
            if (!(var9 instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece var10 = (DesertPyramidPiece)var9;
            var7.addAll(var10.getPotentialSuspiciousSandWorldPositions());
        }
        ObjectArrayList var8 = new ObjectArrayList(var7.stream().toList());
        SystemUtils.shuffle(var8, var3);
        int var9 = Math.min(var7.size(), var3.nextInt(5, 8));
        for (BlockPosition var11 : var8) {
            if (var9 > 0) {
                --var9;
                var0.setBlock(var11, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 2);
                var0.getBlockEntity(var11, TileEntityTypes.SUSPICIOUS_SAND).ifPresent(var1 -> var1.setLootTable(UpdateOneTwentyBuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, var11.asLong()));
                continue;
            }
            var0.setBlock(var11, Blocks.SAND.defaultBlockState(), 2);
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.DESERT_PYRAMID;
    }
}

