/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String INVALID_START_ID = "INVALID";
    public static final StructureStart INVALID_START = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Structure structure;
    private final PiecesContainer pieceContainer;
    private final ChunkCoordIntPair chunkPos;
    private int references;
    @Nullable
    private volatile StructureBoundingBox cachedBoundingBox;

    public StructureStart(Structure var0, ChunkCoordIntPair var1, int var2, PiecesContainer var3) {
        this.structure = var0;
        this.chunkPos = var1;
        this.references = var2;
        this.pieceContainer = var3;
    }

    @Nullable
    public static StructureStart loadStaticStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        String var4 = var1.getString("id");
        if (INVALID_START_ID.equals(var4)) {
            return INVALID_START;
        }
        IRegistry<Structure> var5 = var0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Structure var6 = var5.get(new MinecraftKey(var4));
        if (var6 == null) {
            LOGGER.error("Unknown stucture id: {}", (Object)var4);
            return null;
        }
        ChunkCoordIntPair var7 = new ChunkCoordIntPair(var1.getInt("ChunkX"), var1.getInt("ChunkZ"));
        int var8 = var1.getInt("references");
        NBTTagList var9 = var1.getList("Children", 10);
        try {
            PiecesContainer var10 = PiecesContainer.load(var9, var0);
            if (var6 instanceof OceanMonumentStructure) {
                var10 = OceanMonumentStructure.regeneratePiecesAfterLoad(var7, var2, var10);
            }
            return new StructureStart(var6, var7, var8, var10);
        }
        catch (Exception var10) {
            LOGGER.error("Failed Start with id {}", (Object)var4, (Object)var10);
            return null;
        }
    }

    public StructureBoundingBox getBoundingBox() {
        StructureBoundingBox var0 = this.cachedBoundingBox;
        if (var0 == null) {
            this.cachedBoundingBox = var0 = this.structure.adjustBoundingBox(this.pieceContainer.calculateBoundingBox());
        }
        return var0;
    }

    public void placeInChunk(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5) {
        List<StructurePiece> var6 = this.pieceContainer.pieces();
        if (var6.isEmpty()) {
            return;
        }
        StructureBoundingBox var7 = var6.get((int)0).boundingBox;
        BlockPosition var8 = var7.getCenter();
        BlockPosition var9 = new BlockPosition(var8.getX(), var7.minY(), var8.getZ());
        for (StructurePiece var11 : var6) {
            if (!var11.getBoundingBox().intersects(var4)) continue;
            var11.postProcess(var0, var1, var2, var3, var4, var5, var9);
        }
        this.structure.afterPlace(var0, var1, var2, var3, var4, var5, this.pieceContainer);
    }

    public NBTTagCompound createTag(StructurePieceSerializationContext var0, ChunkCoordIntPair var1) {
        NBTTagCompound var2 = new NBTTagCompound();
        if (!this.isValid()) {
            var2.putString("id", INVALID_START_ID);
            return var2;
        }
        var2.putString("id", var0.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey(this.structure).toString());
        var2.putInt("ChunkX", var1.x);
        var2.putInt("ChunkZ", var1.z);
        var2.putInt("references", this.references);
        var2.put("Children", this.pieceContainer.save(var0));
        return var2;
    }

    public boolean isValid() {
        return !this.pieceContainer.isEmpty();
    }

    public ChunkCoordIntPair getChunkPos() {
        return this.chunkPos;
    }

    public boolean canBeReferenced() {
        return this.references < this.getMaxReferences();
    }

    public void addReference() {
        ++this.references;
    }

    public int getReferences() {
        return this.references;
    }

    protected int getMaxReferences() {
        return 1;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<StructurePiece> getPieces() {
        return this.pieceContainer.pieces();
    }
}

