/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_STRUCTURE = -1;
    private final ChunkScanAccess storageAccess;
    private final IRegistryCustom registryAccess;
    private final IRegistry<BiomeBase> biomes;
    private final IRegistry<Structure> structureConfigs;
    private final StructureTemplateManager structureTemplateManager;
    private final ResourceKey<World> dimension;
    private final ChunkGenerator chunkGenerator;
    private final RandomState randomState;
    private final LevelHeightAccessor heightAccessor;
    private final WorldChunkManager biomeSource;
    private final long seed;
    private final DataFixer fixerUpper;
    private final Long2ObjectMap<Object2IntMap<Structure>> loadedChunks = new Long2ObjectOpenHashMap();
    private final Map<Structure, Long2BooleanMap> featureChecks = new HashMap<Structure, Long2BooleanMap>();

    public StructureCheck(ChunkScanAccess var0, IRegistryCustom var1, StructureTemplateManager var2, ResourceKey<World> var3, ChunkGenerator var4, RandomState var5, LevelHeightAccessor var6, WorldChunkManager var7, long var8, DataFixer var10) {
        this.storageAccess = var0;
        this.registryAccess = var1;
        this.structureTemplateManager = var2;
        this.dimension = var3;
        this.chunkGenerator = var4;
        this.randomState = var5;
        this.heightAccessor = var6;
        this.biomeSource = var7;
        this.seed = var8;
        this.fixerUpper = var10;
        this.biomes = var1.registryOrThrow(Registries.BIOME);
        this.structureConfigs = var1.registryOrThrow(Registries.STRUCTURE);
    }

    public StructureCheckResult checkStart(ChunkCoordIntPair var02, Structure var1, boolean var22) {
        long var3 = var02.toLong();
        Object2IntMap var5 = (Object2IntMap)this.loadedChunks.get(var3);
        if (var5 != null) {
            return this.checkStructureInfo((Object2IntMap<Structure>)var5, var1, var22);
        }
        StructureCheckResult var6 = this.tryLoadFromStorage(var02, var1, var22, var3);
        if (var6 != null) {
            return var6;
        }
        boolean var7 = this.featureChecks.computeIfAbsent(var1, var0 -> new Long2BooleanOpenHashMap()).computeIfAbsent(var3, var2 -> this.canCreateStructure(var02, var1));
        if (!var7) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        return StructureCheckResult.CHUNK_LOAD_NEEDED;
    }

    private boolean canCreateStructure(ChunkCoordIntPair var0, Structure var1) {
        return var1.findValidGenerationPoint(new Structure.a(this.registryAccess, this.chunkGenerator, this.biomeSource, this.randomState, this.structureTemplateManager, this.seed, var0, this.heightAccessor, var1.biomes()::contains)).isPresent();
    }

    @Nullable
    private StructureCheckResult tryLoadFromStorage(ChunkCoordIntPair var0, Structure var1, boolean var2, long var3) {
        NBTTagCompound var9;
        CollectFields var5 = new CollectFields(new FieldSelector(NBTTagInt.TYPE, "DataVersion"), new FieldSelector("Level", "Structures", NBTTagCompound.TYPE, "Starts"), new FieldSelector("structures", NBTTagCompound.TYPE, "starts"));
        try {
            this.storageAccess.scanChunk(var0, var5).join();
        }
        catch (Exception var6) {
            LOGGER.warn("Failed to read chunk {}", (Object)var0, (Object)var6);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        NBTBase var6 = var5.getResult();
        if (!(var6 instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound var7 = (NBTTagCompound)var6;
        int var8 = IChunkLoader.getVersion(var7);
        if (var8 <= 1493) {
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        IChunkLoader.injectDatafixingContext(var7, this.dimension, this.chunkGenerator.getTypeNameForDataFixer());
        try {
            var9 = DataFixTypes.CHUNK.updateToCurrentVersion(this.fixerUpper, var7, var8);
        }
        catch (Exception var10) {
            LOGGER.warn("Failed to partially datafix chunk {}", (Object)var0, (Object)var10);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Object2IntMap<Structure> var10 = this.loadStructures(var9);
        if (var10 == null) {
            return null;
        }
        this.storeFullResults(var3, var10);
        return this.checkStructureInfo(var10, var1, var2);
    }

    @Nullable
    private Object2IntMap<Structure> loadStructures(NBTTagCompound var0) {
        if (!var0.contains("structures", 10)) {
            return null;
        }
        NBTTagCompound var1 = var0.getCompound("structures");
        if (!var1.contains("starts", 10)) {
            return null;
        }
        NBTTagCompound var2 = var1.getCompound("starts");
        if (var2.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        IRegistry<Structure> var4 = this.registryAccess.registryOrThrow(Registries.STRUCTURE);
        for (String var6 : var2.getAllKeys()) {
            String var10;
            NBTTagCompound var9;
            Structure var8;
            MinecraftKey var7 = MinecraftKey.tryParse(var6);
            if (var7 == null || (var8 = var4.get(var7)) == null || (var9 = var2.getCompound(var6)).isEmpty() || "INVALID".equals(var10 = var9.getString("id"))) continue;
            int var11 = var9.getInt("references");
            var3.put((Object)var8, var11);
        }
        return var3;
    }

    private static Object2IntMap<Structure> deduplicateEmptyMap(Object2IntMap<Structure> var0) {
        return var0.isEmpty() ? Object2IntMaps.emptyMap() : var0;
    }

    private StructureCheckResult checkStructureInfo(Object2IntMap<Structure> var0, Structure var1, boolean var2) {
        int var3 = var0.getOrDefault((Object)var1, -1);
        return var3 != -1 && (!var2 || var3 == 0) ? StructureCheckResult.START_PRESENT : StructureCheckResult.START_NOT_PRESENT;
    }

    public void onStructureLoad(ChunkCoordIntPair var0, Map<Structure, StructureStart> var1) {
        long var2 = var0.toLong();
        Object2IntOpenHashMap var4 = new Object2IntOpenHashMap();
        var1.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)var4, arg_0, arg_1));
        this.storeFullResults(var2, (Object2IntMap<Structure>)var4);
    }

    private void storeFullResults(long var0, Object2IntMap<Structure> var22) {
        this.loadedChunks.put(var0, StructureCheck.deduplicateEmptyMap(var22));
        this.featureChecks.values().forEach(var2 -> var2.remove(var0));
    }

    public void incrementReference(ChunkCoordIntPair var0, Structure var1) {
        this.loadedChunks.compute(var0.toLong(), (var12, var2) -> {
            if (var2 == null || var2.isEmpty()) {
                var2 = new Object2IntOpenHashMap();
            }
            var2.computeInt((Object)var1, (var0, var1) -> var1 == null ? 1 : var1 + 1);
            return var2;
        });
    }

    private static /* synthetic */ void a(Object2IntMap var0, Structure var1, StructureStart var2) {
        if (var2.isValid()) {
            var0.put((Object)var1, var2.getReferences());
        }
    }
}

