/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class CherryFoliagePlacer
extends WorldGenFoilagePlacer {
    public static final Codec<CherryFoliagePlacer> CODEC = RecordCodecBuilder.create(var02 -> CherryFoliagePlacer.foliagePlacerParts(var02).and(var02.group((App)IntProvider.codec(4, 16).fieldOf("height").forGetter(var0 -> var0.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wide_bottom_layer_hole_chance").forGetter(var0 -> Float.valueOf(var0.wideBottomLayerHoleChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("corner_hole_chance").forGetter(var0 -> Float.valueOf(var0.wideBottomLayerHoleChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(var0 -> Float.valueOf(var0.hangingLeavesChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(var0 -> Float.valueOf(var0.hangingLeavesExtensionChance)))).apply((Applicative)var02, CherryFoliagePlacer::new));
    private final IntProvider height;
    private final float wideBottomLayerHoleChance;
    private final float cornerHoleChance;
    private final float hangingLeavesChance;
    private final float hangingLeavesExtensionChance;

    public CherryFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2, float var3, float var4, float var5, float var6) {
        super(var0, var1);
        this.height = var2;
        this.wideBottomLayerHoleChance = var3;
        this.cornerHoleChance = var4;
        this.hangingLeavesChance = var5;
        this.hangingLeavesExtensionChance = var6;
    }

    @Override
    protected WorldGenFoilagePlacers<?> type() {
        return WorldGenFoilagePlacers.CHERRY_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(VirtualLevelReadable var0, WorldGenFoilagePlacer.b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, int var4, WorldGenFoilagePlacer.a var5, int var6, int var7, int var8) {
        boolean var9 = var5.doubleTrunk();
        BlockPosition var10 = var5.pos().above(var8);
        int var11 = var7 + var5.radiusOffset() - 1;
        this.placeLeavesRow(var0, var1, var2, var3, var10, var11 - 2, var6 - 3, var9);
        this.placeLeavesRow(var0, var1, var2, var3, var10, var11 - 1, var6 - 4, var9);
        for (int var12 = var6 - 5; var12 >= 0; --var12) {
            this.placeLeavesRow(var0, var1, var2, var3, var10, var11, var12, var9);
        }
        this.placeLeavesRowWithHangingLeavesBelow(var0, var1, var2, var3, var10, var11, -1, var9, this.hangingLeavesChance, this.hangingLeavesExtensionChance);
        this.placeLeavesRowWithHangingLeavesBelow(var0, var1, var2, var3, var10, var11 - 1, -2, var9, this.hangingLeavesChance, this.hangingLeavesExtensionChance);
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, WorldGenFeatureTreeConfiguration var2) {
        return this.height.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        boolean var7;
        if (var2 == -1 && (var1 == var4 || var3 == var4) && var0.nextFloat() < this.wideBottomLayerHoleChance) {
            return true;
        }
        boolean var6 = var1 == var4 && var3 == var4;
        boolean bl = var7 = var4 > 2;
        if (var7) {
            return var6 || var1 + var3 > var4 * 2 - 2 && var0.nextFloat() < this.cornerHoleChance;
        }
        return var6 && var0.nextFloat() < this.cornerHoleChance;
    }
}

