/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.loot.packs.UpdateOneTwentyBuiltInLootTables;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenDesertWell
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final BlockStatePredicate IS_SAND = BlockStatePredicate.forBlock(Blocks.SAND);
    private final IBlockData sandSlab = Blocks.SANDSTONE_SLAB.defaultBlockState();
    private final IBlockData sandstone = Blocks.SANDSTONE.defaultBlockState();
    private final IBlockData water = Blocks.WATER.defaultBlockState();

    public WorldGenDesertWell(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        int var3;
        int var4;
        int var32;
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        var2 = var2.above();
        while (var1.isEmptyBlock(var2) && var2.getY() > var1.getMinBuildHeight() + 2) {
            var2 = var2.below();
        }
        if (!IS_SAND.test(var1.getBlockState(var2))) {
            return false;
        }
        for (var32 = -2; var32 <= 2; ++var32) {
            for (var4 = -2; var4 <= 2; ++var4) {
                if (!var1.isEmptyBlock(var2.offset(var32, -1, var4)) || !var1.isEmptyBlock(var2.offset(var32, -2, var4))) continue;
                return false;
            }
        }
        for (var32 = -1; var32 <= 0; ++var32) {
            for (var4 = -2; var4 <= 2; ++var4) {
                for (int var5 = -2; var5 <= 2; ++var5) {
                    var1.setBlock(var2.offset(var4, var32, var5), this.sandstone, 2);
                }
            }
        }
        if (var1.enabledFeatures().contains(FeatureFlags.UPDATE_1_20)) {
            WorldGenDesertWell.placeSandFloor(var1, var2, var0.random());
        }
        var1.setBlock(var2, this.water, 2);
        for (EnumDirection var42 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var1.setBlock(var2.relative(var42), this.water, 2);
        }
        for (var3 = -2; var3 <= 2; ++var3) {
            for (int var43 = -2; var43 <= 2; ++var43) {
                if (var3 != -2 && var3 != 2 && var43 != -2 && var43 != 2) continue;
                var1.setBlock(var2.offset(var3, 1, var43), this.sandstone, 2);
            }
        }
        var1.setBlock(var2.offset(2, 1, 0), this.sandSlab, 2);
        var1.setBlock(var2.offset(-2, 1, 0), this.sandSlab, 2);
        var1.setBlock(var2.offset(0, 1, 2), this.sandSlab, 2);
        var1.setBlock(var2.offset(0, 1, -2), this.sandSlab, 2);
        for (var3 = -1; var3 <= 1; ++var3) {
            for (int var44 = -1; var44 <= 1; ++var44) {
                if (var3 == 0 && var44 == 0) {
                    var1.setBlock(var2.offset(var3, 4, var44), this.sandstone, 2);
                    continue;
                }
                var1.setBlock(var2.offset(var3, 4, var44), this.sandSlab, 2);
            }
        }
        for (var3 = 1; var3 <= 3; ++var3) {
            var1.setBlock(var2.offset(-1, var3, -1), this.sandstone, 2);
            var1.setBlock(var2.offset(-1, var3, 1), this.sandstone, 2);
            var1.setBlock(var2.offset(1, var3, -1), this.sandstone, 2);
            var1.setBlock(var2.offset(1, var3, 1), this.sandstone, 2);
        }
        return true;
    }

    private static void placeSandFloor(GeneratorAccessSeed var0, BlockPosition var12, RandomSource var22) {
        BlockPosition var3 = var12.offset(0, -1, 0);
        ObjectArrayList var4 = SystemUtils.make(new ObjectArrayList(), var1 -> {
            var1.add((Object)var3.east());
            var1.add((Object)var3.south());
            var1.add((Object)var3.west());
            var1.add((Object)var3.north());
        });
        SystemUtils.shuffle(var4, var22);
        MutableInt var5 = new MutableInt(var22.nextInt(2, 4));
        Stream.concat(Stream.of(var3), var4.stream()).forEach(var2 -> {
            if (var5.getAndDecrement() > 0) {
                var0.setBlock((BlockPosition)var2, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 3);
                var0.getBlockEntity((BlockPosition)var2, TileEntityTypes.SUSPICIOUS_SAND).ifPresent(var1 -> var1.setLootTable(UpdateOneTwentyBuiltInLootTables.DESERT_WELL_ARCHAEOLOGY, var2.asLong()));
            } else {
                var0.setBlock((BlockPosition)var2, Blocks.SAND.defaultBlockState(), 3);
            }
        });
    }
}

