/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public interface VerticalAnchor {
    public static final Codec<VerticalAnchor> CODEC = ExtraCodecs.xor(b.CODEC, ExtraCodecs.xor(a.CODEC, c.CODEC)).xmap(VerticalAnchor::merge, VerticalAnchor::split);
    public static final VerticalAnchor BOTTOM = VerticalAnchor.aboveBottom(0);
    public static final VerticalAnchor TOP = VerticalAnchor.belowTop(0);

    public static VerticalAnchor absolute(int var0) {
        return new b(var0);
    }

    public static VerticalAnchor aboveBottom(int var0) {
        return new a(var0);
    }

    public static VerticalAnchor belowTop(int var0) {
        return new c(var0);
    }

    public static VerticalAnchor bottom() {
        return BOTTOM;
    }

    public static VerticalAnchor top() {
        return TOP;
    }

    private static VerticalAnchor merge(Either<b, Either<a, c>> var02) {
        return (VerticalAnchor)var02.map(Function.identity(), var0 -> (Record)var0.map(Function.identity(), Function.identity()));
    }

    private static Either<b, Either<a, c>> split(VerticalAnchor var0) {
        if (var0 instanceof b) {
            return Either.left((Object)((b)var0));
        }
        return Either.right((Object)(var0 instanceof a ? Either.left((Object)((a)var0)) : Either.right((Object)((c)var0))));
    }

    public int resolveY(WorldGenerationContext var1);

    public record b(int y) implements VerticalAnchor
    {
        public static final Codec<b> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("absolute").xmap(b::new, b::y).codec();

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return this.y;
        }

        @Override
        public String toString() {
            return this.y + " absolute";
        }
    }

    public record a(int offset) implements VerticalAnchor
    {
        public static final Codec<a> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("above_bottom").xmap(a::new, a::offset).codec();

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return var0.getMinGenY() + this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " above bottom";
        }
    }

    public record c(int offset) implements VerticalAnchor
    {
        public static final Codec<c> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("below_top").xmap(c::new, c::offset).codec();

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return var0.getGenDepth() - 1 + var0.getMinGenY() - this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " below top";
        }
    }
}

