/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.FastBufferedInputStream;

public class RegionFileCompression {
    private static final Int2ObjectMap<RegionFileCompression> VERSIONS = new Int2ObjectOpenHashMap();
    public static final RegionFileCompression VERSION_GZIP = RegionFileCompression.register(new RegionFileCompression(1, var0 -> new FastBufferedInputStream(new GZIPInputStream((InputStream)var0)), var0 -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)var0))));
    public static final RegionFileCompression VERSION_DEFLATE = RegionFileCompression.register(new RegionFileCompression(2, var0 -> new FastBufferedInputStream(new InflaterInputStream((InputStream)var0)), var0 -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)var0))));
    public static final RegionFileCompression VERSION_NONE = RegionFileCompression.register(new RegionFileCompression(3, var0 -> var0, var0 -> var0));
    private final int id;
    private final a<InputStream> inputWrapper;
    private final a<OutputStream> outputWrapper;

    private RegionFileCompression(int var0, a<InputStream> var1, a<OutputStream> var2) {
        this.id = var0;
        this.inputWrapper = var1;
        this.outputWrapper = var2;
    }

    private static RegionFileCompression register(RegionFileCompression var0) {
        VERSIONS.put(var0.id, (Object)var0);
        return var0;
    }

    @Nullable
    public static RegionFileCompression fromId(int var0) {
        return (RegionFileCompression)VERSIONS.get(var0);
    }

    public static boolean isValidVersion(int var0) {
        return VERSIONS.containsKey(var0);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream var0) throws IOException {
        return this.outputWrapper.wrap(var0);
    }

    public InputStream wrap(InputStream var0) throws IOException {
        return this.inputWrapper.wrap(var0);
    }

    @FunctionalInterface
    static interface a<O> {
        public O wrap(O var1) throws IOException;
    }
}

