/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.Fluid;

public class ChunkSection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    public static final int BIOME_CONTAINER_BITS = 2;
    private final int bottomBlockY;
    private short nonEmptyBlockCount;
    private short tickingBlockCount;
    private short tickingFluidCount;
    private final DataPaletteBlock<IBlockData> states;
    private PalettedContainerRO<Holder<BiomeBase>> biomes;

    public ChunkSection(int var0, DataPaletteBlock<IBlockData> var1, PalettedContainerRO<Holder<BiomeBase>> var2) {
        this.bottomBlockY = ChunkSection.getBottomBlockY(var0);
        this.states = var1;
        this.biomes = var2;
        this.recalcBlockCounts();
    }

    public ChunkSection(int var0, IRegistry<BiomeBase> var1) {
        this.bottomBlockY = ChunkSection.getBottomBlockY(var0);
        this.states = new DataPaletteBlock<IBlockData>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.d.SECTION_STATES);
        this.biomes = new DataPaletteBlock<Holder.c<BiomeBase>>(var1.asHolderIdMap(), var1.getHolderOrThrow(Biomes.PLAINS), DataPaletteBlock.d.SECTION_BIOMES);
    }

    public static int getBottomBlockY(int var0) {
        return var0 << 4;
    }

    public IBlockData getBlockState(int var0, int var1, int var2) {
        return this.states.get(var0, var1, var2);
    }

    public Fluid getFluidState(int var0, int var1, int var2) {
        return this.states.get(var0, var1, var2).getFluidState();
    }

    public void acquire() {
        this.states.acquire();
    }

    public void release() {
        this.states.release();
    }

    public IBlockData setBlockState(int var0, int var1, int var2, IBlockData var3) {
        return this.setBlockState(var0, var1, var2, var3, true);
    }

    public IBlockData setBlockState(int var0, int var1, int var2, IBlockData var3, boolean var4) {
        IBlockData var5 = var4 ? this.states.getAndSet(var0, var1, var2, var3) : this.states.getAndSetUnchecked(var0, var1, var2, var3);
        Fluid var6 = var5.getFluidState();
        Fluid var7 = var3.getFluidState();
        if (!var5.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (var5.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount - 1);
            }
        }
        if (!var6.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount - 1);
        }
        if (!var3.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (var3.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount + 1);
            }
        }
        if (!var7.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount + 1);
        }
        return var5;
    }

    public boolean hasOnlyAir() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTickingBlocks() || this.isRandomlyTickingFluids();
    }

    public boolean isRandomlyTickingBlocks() {
        return this.tickingBlockCount > 0;
    }

    public boolean isRandomlyTickingFluids() {
        return this.tickingFluidCount > 0;
    }

    public int bottomBlockY() {
        return this.bottomBlockY;
    }

    public void recalcBlockCounts() {
        class A
        implements DataPaletteBlock.b<IBlockData> {
            public int nonEmptyBlockCount;
            public int tickingBlockCount;
            public int tickingFluidCount;

            A() {
            }

            @Override
            public void accept(IBlockData var0, int var1) {
                Fluid var2 = var0.getFluidState();
                if (!var0.isAir()) {
                    this.nonEmptyBlockCount += var1;
                    if (var0.isRandomlyTicking()) {
                        this.tickingBlockCount += var1;
                    }
                }
                if (!var2.isEmpty()) {
                    this.nonEmptyBlockCount += var1;
                    if (var2.isRandomlyTicking()) {
                        this.tickingFluidCount += var1;
                    }
                }
            }

            @Override
            public /* synthetic */ void accept(Object object, int n2) {
                this.accept((IBlockData)object, n2);
            }
        }
        A var0 = new A();
        this.states.count(var0);
        this.nonEmptyBlockCount = (short)var0.nonEmptyBlockCount;
        this.tickingBlockCount = (short)var0.tickingBlockCount;
        this.tickingFluidCount = (short)var0.tickingFluidCount;
    }

    public DataPaletteBlock<IBlockData> getStates() {
        return this.states;
    }

    public PalettedContainerRO<Holder<BiomeBase>> getBiomes() {
        return this.biomes;
    }

    public void read(PacketDataSerializer var0) {
        this.nonEmptyBlockCount = var0.readShort();
        this.states.read(var0);
        DataPaletteBlock<Holder<BiomeBase>> var1 = this.biomes.recreate();
        var1.read(var0);
        this.biomes = var1;
    }

    public void readBiomes(PacketDataSerializer var0) {
        DataPaletteBlock<Holder<BiomeBase>> var1 = this.biomes.recreate();
        var1.read(var0);
        this.biomes = var1;
    }

    public void write(PacketDataSerializer var0) {
        var0.writeShort(this.nonEmptyBlockCount);
        this.states.write(var0);
        this.biomes.write(var0);
    }

    public int getSerializedSize() {
        return 2 + this.states.getSerializedSize() + this.biomes.getSerializedSize();
    }

    public boolean maybeHas(Predicate<IBlockData> var0) {
        return this.states.maybeHas(var0);
    }

    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        return this.biomes.get(var0, var1, var2);
    }

    public void fillBiomesFromNoise(BiomeResolver var0, Climate.Sampler var1, int var2, int var3) {
        DataPaletteBlock<Holder<BiomeBase>> var4 = this.biomes.recreate();
        int var5 = QuartPos.fromBlock(this.bottomBlockY());
        int var6 = 4;
        for (int var7 = 0; var7 < 4; ++var7) {
            for (int var8 = 0; var8 < 4; ++var8) {
                for (int var9 = 0; var9 < 4; ++var9) {
                    var4.getAndSetUnchecked(var7, var8, var9, var0.getNoiseBiome(var2 + var7, var5 + var8, var3 + var9, var1));
                }
            }
        }
        this.biomes = var4;
    }
}

