/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;

public final class BlockPropertyInstrument
extends Enum<BlockPropertyInstrument>
implements INamable {
    public static final /* enum */ BlockPropertyInstrument HARP = new BlockPropertyInstrument("harp", SoundEffects.NOTE_BLOCK_HARP, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument BASEDRUM = new BlockPropertyInstrument("basedrum", SoundEffects.NOTE_BLOCK_BASEDRUM, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument SNARE = new BlockPropertyInstrument("snare", SoundEffects.NOTE_BLOCK_SNARE, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument HAT = new BlockPropertyInstrument("hat", SoundEffects.NOTE_BLOCK_HAT, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument BASS = new BlockPropertyInstrument("bass", SoundEffects.NOTE_BLOCK_BASS, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument FLUTE = new BlockPropertyInstrument("flute", SoundEffects.NOTE_BLOCK_FLUTE, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument BELL = new BlockPropertyInstrument("bell", SoundEffects.NOTE_BLOCK_BELL, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument GUITAR = new BlockPropertyInstrument("guitar", SoundEffects.NOTE_BLOCK_GUITAR, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument CHIME = new BlockPropertyInstrument("chime", SoundEffects.NOTE_BLOCK_CHIME, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument XYLOPHONE = new BlockPropertyInstrument("xylophone", SoundEffects.NOTE_BLOCK_XYLOPHONE, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument IRON_XYLOPHONE = new BlockPropertyInstrument("iron_xylophone", SoundEffects.NOTE_BLOCK_IRON_XYLOPHONE, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument COW_BELL = new BlockPropertyInstrument("cow_bell", SoundEffects.NOTE_BLOCK_COW_BELL, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument DIDGERIDOO = new BlockPropertyInstrument("didgeridoo", SoundEffects.NOTE_BLOCK_DIDGERIDOO, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument BIT = new BlockPropertyInstrument("bit", SoundEffects.NOTE_BLOCK_BIT, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument BANJO = new BlockPropertyInstrument("banjo", SoundEffects.NOTE_BLOCK_BANJO, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument PLING = new BlockPropertyInstrument("pling", SoundEffects.NOTE_BLOCK_PLING, a.BASE_BLOCK);
    public static final /* enum */ BlockPropertyInstrument ZOMBIE = new BlockPropertyInstrument("zombie", SoundEffects.NOTE_BLOCK_IMITATE_ZOMBIE, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument SKELETON = new BlockPropertyInstrument("skeleton", SoundEffects.NOTE_BLOCK_IMITATE_SKELETON, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument CREEPER = new BlockPropertyInstrument("creeper", SoundEffects.NOTE_BLOCK_IMITATE_CREEPER, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument DRAGON = new BlockPropertyInstrument("dragon", SoundEffects.NOTE_BLOCK_IMITATE_ENDER_DRAGON, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument WITHER_SKELETON = new BlockPropertyInstrument("wither_skeleton", SoundEffects.NOTE_BLOCK_IMITATE_WITHER_SKELETON, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument PIGLIN = new BlockPropertyInstrument("piglin", SoundEffects.NOTE_BLOCK_IMITATE_PIGLIN, a.MOB_HEAD);
    public static final /* enum */ BlockPropertyInstrument CUSTOM_HEAD = new BlockPropertyInstrument("custom_head", SoundEffects.UI_BUTTON_CLICK, a.CUSTOM);
    private final String name;
    private final Holder<SoundEffect> soundEvent;
    private final a type;
    private static final /* synthetic */ BlockPropertyInstrument[] A;

    public static BlockPropertyInstrument[] values() {
        return (BlockPropertyInstrument[])A.clone();
    }

    public static BlockPropertyInstrument valueOf(String var0) {
        return Enum.valueOf(BlockPropertyInstrument.class, var0);
    }

    private BlockPropertyInstrument(String var2, Holder var3, a var4) {
        this.name = var2;
        this.soundEvent = var3;
        this.type = var4;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public Holder<SoundEffect> getSoundEvent() {
        return this.soundEvent;
    }

    public boolean isTunable() {
        return this.type == a.BASE_BLOCK;
    }

    public boolean hasCustomSound() {
        return this.type == a.CUSTOM;
    }

    public boolean requiresAirAbove() {
        return this.type == a.BASE_BLOCK;
    }

    public static Optional<BlockPropertyInstrument> byStateAbove(IBlockData var0) {
        if (var0.is(Blocks.ZOMBIE_HEAD)) {
            return Optional.of(ZOMBIE);
        }
        if (var0.is(Blocks.SKELETON_SKULL)) {
            return Optional.of(SKELETON);
        }
        if (var0.is(Blocks.CREEPER_HEAD)) {
            return Optional.of(CREEPER);
        }
        if (var0.is(Blocks.DRAGON_HEAD)) {
            return Optional.of(DRAGON);
        }
        if (var0.is(Blocks.WITHER_SKELETON_SKULL)) {
            return Optional.of(WITHER_SKELETON);
        }
        if (var0.is(Blocks.PIGLIN_HEAD)) {
            return Optional.of(PIGLIN);
        }
        if (var0.is(Blocks.PLAYER_HEAD)) {
            return Optional.of(CUSTOM_HEAD);
        }
        return Optional.empty();
    }

    public static BlockPropertyInstrument byStateBelow(IBlockData var0) {
        if (var0.is(Blocks.CLAY)) {
            return FLUTE;
        }
        if (var0.is(Blocks.GOLD_BLOCK)) {
            return BELL;
        }
        if (var0.is(TagsBlock.WOOL)) {
            return GUITAR;
        }
        if (var0.is(Blocks.PACKED_ICE)) {
            return CHIME;
        }
        if (var0.is(Blocks.BONE_BLOCK)) {
            return XYLOPHONE;
        }
        if (var0.is(Blocks.IRON_BLOCK)) {
            return IRON_XYLOPHONE;
        }
        if (var0.is(Blocks.SOUL_SAND)) {
            return COW_BELL;
        }
        if (var0.is(Blocks.PUMPKIN)) {
            return DIDGERIDOO;
        }
        if (var0.is(Blocks.EMERALD_BLOCK)) {
            return BIT;
        }
        if (var0.is(Blocks.HAY_BLOCK)) {
            return BANJO;
        }
        if (var0.is(Blocks.GLOWSTONE)) {
            return PLING;
        }
        Material var1 = var0.getMaterial();
        if (var1 == Material.STONE) {
            return BASEDRUM;
        }
        if (var1 == Material.SAND) {
            return SNARE;
        }
        if (var1 == Material.GLASS) {
            return HAT;
        }
        if (var1 == Material.WOOD || var1 == Material.NETHER_WOOD) {
            return BASS;
        }
        return HARP;
    }

    private static /* synthetic */ BlockPropertyInstrument[] f() {
        return new BlockPropertyInstrument[]{HARP, BASEDRUM, SNARE, HAT, BASS, FLUTE, BELL, GUITAR, CHIME, XYLOPHONE, IRON_XYLOPHONE, COW_BELL, DIDGERIDOO, BIT, BANJO, PLING, ZOMBIE, SKELETON, CREEPER, DRAGON, WITHER_SKELETON, PIGLIN, CUSTOM_HEAD};
    }

    static {
        A = BlockPropertyInstrument.f();
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a BASE_BLOCK = new a();
        public static final /* enum */ a MOB_HEAD = new a();
        public static final /* enum */ a CUSTOM = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{BASE_BLOCK, MOB_HEAD, CUSTOM};
        }

        static {
            d = a.a();
        }
    }
}

