/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public abstract class WorldGenTreeProvider {
    @Nullable
    protected abstract ResourceKey<WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(RandomSource var1, boolean var2);

    public boolean growTree(WorldServer var0, ChunkGenerator var1, BlockPosition var2, IBlockData var3, RandomSource var4) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> var5 = this.getConfiguredFeature(var4, this.hasFlowers(var0, var2));
        if (var5 == null) {
            return false;
        }
        Holder var6 = var0.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(var5).orElse(null);
        if (var6 == null) {
            return false;
        }
        WorldGenFeatureConfigured var7 = (WorldGenFeatureConfigured)var6.value();
        IBlockData var8 = var0.getFluidState(var2).createLegacyBlock();
        var0.setBlock(var2, var8, 4);
        if (var7.place(var0, var1, var4, var2)) {
            if (var0.getBlockState(var2) == var8) {
                var0.sendBlockUpdated(var2, var3, var8, 2);
            }
            return true;
        }
        var0.setBlock(var2, var3, 4);
        return false;
    }

    private boolean hasFlowers(GeneratorAccess var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.MutableBlockPosition.betweenClosed(var1.below().north(2).west(2), var1.above().south(2).east(2))) {
            if (!var0.getBlockState(var3).is(TagsBlock.FLOWERS)) continue;
            return true;
        }
        return false;
    }
}

