/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String TAG_SKULL_OWNER = "SkullOwner";
    public static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    @Nullable
    private static UserCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    public GameProfile owner;
    @Nullable
    public MinecraftKey noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;

    public TileEntitySkull(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SKULL, var0, var1);
    }

    public static void setup(Services var0, Executor var1) {
        profileCache = var0.profileCache();
        sessionService = var0.sessionService();
        mainThreadExecutor = var1;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (this.owner != null) {
            NBTTagCompound var1 = new NBTTagCompound();
            GameProfileSerializer.writeGameProfile(var1, this.owner);
            var0.put(TAG_SKULL_OWNER, var1);
        }
        if (this.noteBlockSound != null) {
            var0.putString(TAG_NOTE_BLOCK_SOUND, this.noteBlockSound.toString());
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        String var1;
        super.load(var0);
        if (var0.contains(TAG_SKULL_OWNER, 10)) {
            this.setOwner(GameProfileSerializer.readGameProfile(var0.getCompound(TAG_SKULL_OWNER)));
        } else if (var0.contains("ExtraType", 8) && !UtilColor.isNullOrEmpty(var1 = var0.getString("ExtraType"))) {
            this.setOwner(new GameProfile(null, var1));
        }
        if (var0.contains(TAG_NOTE_BLOCK_SOUND, 8)) {
            this.noteBlockSound = MinecraftKey.tryParse(var0.getString(TAG_NOTE_BLOCK_SOUND));
        }
    }

    public static void animation(World var0, BlockPosition var1, IBlockData var2, TileEntitySkull var3) {
        if (var0.hasNeighborSignal(var1)) {
            var3.isAnimating = true;
            ++var3.animationTickCount;
        } else {
            var3.isAnimating = false;
        }
    }

    public float getAnimation(float var0) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + var0;
        }
        return this.animationTickCount;
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public MinecraftKey getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile var0) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.owner = var0;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        TileEntitySkull.updateGameprofile(this.owner, var0 -> {
            this.owner = var0;
            this.setChanged();
        });
    }

    public static void updateGameprofile(@Nullable GameProfile var0, Consumer<GameProfile> var1) {
        if (var0 == null || UtilColor.isNullOrEmpty(var0.getName()) || var0.isComplete() && var0.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null) {
            var1.accept(var0);
            return;
        }
        profileCache.getAsync(var0.getName(), var2 -> SystemUtils.backgroundExecutor().execute(() -> SystemUtils.ifElse(var2, var1 -> {
            MinecraftSessionService var3;
            GameProfile var0 = (Property)Iterables.getFirst((Iterable)var1.getProperties().get((Object)"textures"), null);
            if (var0 == null) {
                var3 = sessionService;
                if (var3 == null) {
                    return;
                }
                var1 = var3.fillProfileProperties(var1, true);
            }
            var3 = var1;
            Executor var4 = mainThreadExecutor;
            if (var4 != null) {
                var4.execute(() -> TileEntitySkull.b((GameProfile)var3, var1));
            }
        }, () -> {
            GameProfile var0 = mainThreadExecutor;
            if (var0 != null) {
                var0.execute(() -> var1.accept(var0));
            }
        })));
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    private static /* synthetic */ void b(GameProfile var0, Consumer var1) {
        UserCache var2 = profileCache;
        if (var2 != null) {
            var2.add(var0);
            var1.accept(var0);
        }
    }
}

