/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public abstract class TileEntityLootable
extends TileEntityContainer {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    @Nullable
    public MinecraftKey lootTable;
    public long lootTableSeed;

    protected TileEntityLootable(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    public static void setLootTable(IBlockAccess var0, RandomSource var1, BlockPosition var2, MinecraftKey var3) {
        TileEntity var4 = var0.getBlockEntity(var2);
        if (var4 instanceof TileEntityLootable) {
            ((TileEntityLootable)var4).setLootTable(var3, var1.nextLong());
        }
    }

    protected boolean tryLoadLootTable(NBTTagCompound var0) {
        if (var0.contains(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new MinecraftKey(var0.getString(LOOT_TABLE_TAG));
            this.lootTableSeed = var0.getLong(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(NBTTagCompound var0) {
        if (this.lootTable == null) {
            return false;
        }
        var0.putString(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    public void unpackLootTable(@Nullable EntityHuman var0) {
        if (this.lootTable != null && this.level.getServer() != null) {
            LootTable var1 = this.level.getServer().getLootTables().get(this.lootTable);
            if (var0 instanceof EntityPlayer) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, this.lootTable);
            }
            this.lootTable = null;
            LootTableInfo.Builder var2 = new LootTableInfo.Builder((WorldServer)this.level).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(this.worldPosition)).withOptionalRandomSeed(this.lootTableSeed);
            if (var0 != null) {
                var2.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var1.fill(this, var2.create(LootContextParameterSets.CHEST));
        }
    }

    public void setLootTable(MinecraftKey var0, long var1) {
        this.lootTable = var0;
        this.lootTableSeed = var1;
    }

    @Override
    public boolean isEmpty() {
        this.unpackLootTable(null);
        return this.getItems().stream().allMatch(ItemStack::isEmpty);
    }

    @Override
    public ItemStack getItem(int var0) {
        this.unpackLootTable(null);
        return this.getItems().get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        this.unpackLootTable(null);
        ItemStack var2 = ContainerUtil.removeItem(this.getItems(), var0, var1);
        if (!var2.isEmpty()) {
            this.setChanged();
        }
        return var2;
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        this.unpackLootTable(null);
        return ContainerUtil.takeItem(this.getItems(), var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.unpackLootTable(null);
        this.getItems().set(var0, var1);
        if (var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    @Override
    public void clearContent() {
        this.getItems().clear();
    }

    protected abstract NonNullList<ItemStack> getItems();

    protected abstract void setItems(NonNullList<ItemStack> var1);

    @Override
    public boolean canOpen(EntityHuman var0) {
        return super.canOpen(var0) && (this.lootTable == null || !var0.isSpectator());
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.canOpen(var2)) {
            this.unpackLootTable(var1.player);
            return this.createMenu(var0, var1);
        }
        return null;
    }
}

