/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class TileEntityCampfire
extends TileEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.withSize(4, ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];
    private final CraftingManager.a<IInventory, RecipeCampfire> quickCheck = CraftingManager.createCheck(Recipes.CAMPFIRE_COOKING);

    public TileEntityCampfire(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CAMPFIRE, var0, var1);
    }

    public static void cookTick(World var0, BlockPosition var1, IBlockData var22, TileEntityCampfire var3) {
        boolean var4 = false;
        for (int var5 = 0; var5 < var3.items.size(); ++var5) {
            InventorySubcontainer var7;
            ItemStack var8;
            ItemStack var6 = var3.items.get(var5);
            if (var6.isEmpty()) continue;
            var4 = true;
            int n2 = var5;
            var3.cookingProgress[n2] = var3.cookingProgress[n2] + 1;
            if (var3.cookingProgress[var5] < var3.cookingTime[var5] || !(var8 = var3.quickCheck.getRecipeFor(var7 = new InventorySubcontainer(var6), var0).map(var2 -> var2.assemble(var7, var0.registryAccess())).orElse(var6)).isItemEnabled(var0.enabledFeatures())) continue;
            InventoryUtils.dropItemStack(var0, var1.getX(), var1.getY(), var1.getZ(), var8);
            var3.items.set(var5, ItemStack.EMPTY);
            var0.sendBlockUpdated(var1, var22, var22, 3);
            var0.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.a.of(var22));
        }
        if (var4) {
            TileEntityCampfire.setChanged(var0, var1, var22);
        }
    }

    public static void cooldownTick(World var0, BlockPosition var1, IBlockData var2, TileEntityCampfire var3) {
        boolean var4 = false;
        for (int var5 = 0; var5 < var3.items.size(); ++var5) {
            if (var3.cookingProgress[var5] <= 0) continue;
            var4 = true;
            var3.cookingProgress[var5] = MathHelper.clamp(var3.cookingProgress[var5] - 2, 0, var3.cookingTime[var5]);
        }
        if (var4) {
            TileEntityCampfire.setChanged(var0, var1, var2);
        }
    }

    public static void particleTick(World var0, BlockPosition var1, IBlockData var2, TileEntityCampfire var3) {
        int var5;
        RandomSource var4 = var0.random;
        if (var4.nextFloat() < 0.11f) {
            for (var5 = 0; var5 < var4.nextInt(2) + 2; ++var5) {
                BlockCampfire.makeParticles(var0, var1, var2.getValue(BlockCampfire.SIGNAL_FIRE), false);
            }
        }
        var5 = var2.getValue(BlockCampfire.FACING).get2DDataValue();
        for (int var6 = 0; var6 < var3.items.size(); ++var6) {
            if (var3.items.get(var6).isEmpty() || !(var4.nextFloat() < 0.2f)) continue;
            EnumDirection var7 = EnumDirection.from2DDataValue(Math.floorMod(var6 + var5, 4));
            float var8 = 0.3125f;
            double var9 = (double)var1.getX() + 0.5 - (double)((float)var7.getStepX() * 0.3125f) + (double)((float)var7.getClockWise().getStepX() * 0.3125f);
            double var11 = (double)var1.getY() + 0.5;
            double var13 = (double)var1.getZ() + 0.5 - (double)((float)var7.getStepZ() * 0.3125f) + (double)((float)var7.getClockWise().getStepZ() * 0.3125f);
            for (int var15 = 0; var15 < 4; ++var15) {
                var0.addParticle(Particles.SMOKE, var9, var11, var13, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void load(NBTTagCompound var0) {
        int[] var1;
        super.load(var0);
        this.items.clear();
        ContainerUtil.loadAllItems(var0, this.items);
        if (var0.contains("CookingTimes", 11)) {
            var1 = var0.getIntArray("CookingTimes");
            System.arraycopy(var1, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, var1.length));
        }
        if (var0.contains("CookingTotalTimes", 11)) {
            var1 = var0.getIntArray("CookingTotalTimes");
            System.arraycopy(var1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, var1.length));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        ContainerUtil.saveAllItems(var0, this.items, true);
        var0.putIntArray("CookingTimes", this.cookingProgress);
        var0.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        NBTTagCompound var0 = new NBTTagCompound();
        ContainerUtil.saveAllItems(var0, this.items, true);
        return var0;
    }

    public Optional<RecipeCampfire> getCookableRecipe(ItemStack var0) {
        if (this.items.stream().noneMatch(ItemStack::isEmpty)) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor(new InventorySubcontainer(var0), this.level);
    }

    public boolean placeFood(@Nullable Entity var0, ItemStack var1, int var2) {
        for (int var3 = 0; var3 < this.items.size(); ++var3) {
            ItemStack var4 = this.items.get(var3);
            if (!var4.isEmpty()) continue;
            this.cookingTime[var3] = var2;
            this.cookingProgress[var3] = 0;
            this.items.set(var3, var1.split(1));
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.a.of(var0, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

