/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import org.slf4j.Logger;

public class SculkSensorBlockEntity
extends TileEntity
implements VibrationListener.a {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationListener listener;
    public int lastVibrationFrequency;

    public SculkSensorBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_SENSOR, var0, var1);
        this.listener = new VibrationListener(new BlockPositionSource(this.worldPosition), ((SculkSensorBlock)var1.getBlock()).getListenerRange(), this);
    }

    @Override
    public void load(NBTTagCompound var02) {
        super.load(var02);
        this.lastVibrationFrequency = var02.getInt("last_vibration_frequency");
        if (var02.contains("listener", 10)) {
            VibrationListener.codec(this).parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.listener = var0;
            });
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putInt("last_vibration_frequency", this.lastVibrationFrequency);
        VibrationListener.codec(this).encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("listener", (NBTBase)var1));
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    @Override
    public boolean canTriggerAvoidVibration() {
        return true;
    }

    @Override
    public boolean shouldListen(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, @Nullable GameEvent.a var4) {
        if (var2.equals(this.getBlockPos()) && (var3 == GameEvent.BLOCK_DESTROY || var3 == GameEvent.BLOCK_PLACE)) {
            return false;
        }
        return SculkSensorBlock.canActivate(this.getBlockState());
    }

    @Override
    public void onSignalReceive(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, @Nullable Entity var4, @Nullable Entity var5, float var6) {
        IBlockData var7 = this.getBlockState();
        if (SculkSensorBlock.canActivate(var7)) {
            this.lastVibrationFrequency = VibrationListener.getGameEventFrequency(var3);
            SculkSensorBlock.activate(var4, var0, this.worldPosition, var7, SculkSensorBlockEntity.getRedstoneStrengthForDistance(var6, var1.getListenerRadius()));
        }
    }

    @Override
    public void onSignalSchedule() {
        this.setChanged();
    }

    public static int getRedstoneStrengthForDistance(float var0, int var1) {
        double var2 = (double)var0 / (double)var1;
        return Math.max(1, 15 - MathHelper.floor(var2 * 15.0));
    }

    public void setLastVibrationFrequency(int var0) {
        this.lastVibrationFrequency = var0;
    }
}

