/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3D;

public class SculkCatalystBlockEntity
extends TileEntity
implements GameEventListener {
    private final BlockPositionSource blockPosSource;
    private final SculkSpreader sculkSpreader;

    public SculkCatalystBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_CATALYST, var0, var1);
        this.blockPosSource = new BlockPositionSource(this.worldPosition);
        this.sculkSpreader = SculkSpreader.createLevelSpreader();
    }

    @Override
    public PositionSource getListenerSource() {
        return this.blockPosSource;
    }

    @Override
    public int getListenerRadius() {
        return 8;
    }

    @Override
    public GameEventListener.a getDeliveryMode() {
        return GameEventListener.a.BY_DISTANCE;
    }

    @Override
    public boolean handleGameEvent(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3) {
        Entity entity;
        if (var1 == GameEvent.ENTITY_DIE && (entity = var2.sourceEntity()) instanceof EntityLiving) {
            EntityLiving var4 = (EntityLiving)entity;
            if (!var4.wasExperienceConsumed()) {
                int var5 = var4.getExperienceReward();
                if (var4.shouldDropExperience() && var5 > 0) {
                    this.sculkSpreader.addCursors(BlockPosition.containing(var3.relative(EnumDirection.UP, 0.5)), var5);
                    this.tryAwardItSpreadsAdvancement(var4);
                }
                var4.skipDropExperience();
                SculkCatalystBlock.bloom(var0, this.worldPosition, this.getBlockState(), var0.getRandom());
            }
            return true;
        }
        return false;
    }

    private void tryAwardItSpreadsAdvancement(EntityLiving var0) {
        EntityLiving var1 = var0.getLastHurtByMob();
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            DamageSource var3 = var0.getLastDamageSource() == null ? this.level.damageSources().playerAttack(var2) : var0.getLastDamageSource();
            CriterionTriggers.KILL_MOB_NEAR_SCULK_CATALYST.trigger(var2, var0, var3);
        }
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, SculkCatalystBlockEntity var3) {
        var3.sculkSpreader.updateCursors(var0, var1, var0.getRandom(), true);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.sculkSpreader.load(var0);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        this.sculkSpreader.save(var0);
        super.saveAdditional(var0);
    }

    @VisibleForTesting
    public SculkSpreader getSculkSpreader() {
        return this.sculkSpreader;
    }

    private static /* synthetic */ Integer a(SculkSpreader.a var0) {
        return 1;
    }
}

