/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class DecoratedPotPatterns {
    public static final String BASE_NAME = "decorated_pot_base";
    public static final ResourceKey<String> BASE = DecoratedPotPatterns.create("decorated_pot_base");
    public static final String BRICK_NAME = "decorated_pot_side";
    public static final String ARCHER_NAME = "pottery_pattern_archer";
    public static final String PRIZE_NAME = "pottery_pattern_prize";
    public static final String ARMS_UP_NAME = "pottery_pattern_arms_up";
    public static final String SKULL_NAME = "pottery_pattern_skull";
    public static final ResourceKey<String> BRICK = DecoratedPotPatterns.create("decorated_pot_side");
    public static final ResourceKey<String> ARCHER = DecoratedPotPatterns.create("pottery_pattern_archer");
    public static final ResourceKey<String> PRIZE = DecoratedPotPatterns.create("pottery_pattern_prize");
    public static final ResourceKey<String> ARMS_UP = DecoratedPotPatterns.create("pottery_pattern_arms_up");
    public static final ResourceKey<String> SKULL = DecoratedPotPatterns.create("pottery_pattern_skull");
    private static final Map<Item, ResourceKey<String>> ITEM_TO_POT_TEXTURE = Map.ofEntries(Map.entry(Items.POTTERY_SHARD_ARCHER, ARCHER), Map.entry(Items.POTTERY_SHARD_PRIZE, PRIZE), Map.entry(Items.POTTERY_SHARD_ARMS_UP, ARMS_UP), Map.entry(Items.POTTERY_SHARD_SKULL, SKULL), Map.entry(Items.BRICK, BRICK));

    private static ResourceKey<String> create(String var0) {
        return ResourceKey.create(Registries.DECORATED_POT_PATTERNS, new MinecraftKey(var0));
    }

    public static MinecraftKey location(ResourceKey<String> var0) {
        return var0.location().withPrefix("entity/decorated_pot/");
    }

    @Nullable
    public static ResourceKey<String> getResourceKey(Item var0) {
        return ITEM_TO_POT_TEXTURE.get(var0);
    }

    public static String bootstrap(IRegistry<String> var0) {
        IRegistry.register(var0, ARCHER, ARCHER_NAME);
        IRegistry.register(var0, PRIZE, PRIZE_NAME);
        IRegistry.register(var0, ARMS_UP, ARMS_UP_NAME);
        IRegistry.register(var0, SKULL, SKULL_NAME);
        IRegistry.register(var0, BRICK, BRICK_NAME);
        return IRegistry.register(var0, BASE, BASE_NAME);
    }
}

