/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;

public class DecoratedPotBlockEntity
extends TileEntity {
    private static final String TAG_SHARDS = "shards";
    private static final int SHARDS_IN_POT = 4;
    private boolean isBroken = false;
    private final List<Item> shards = SystemUtils.make(new ArrayList(4), var0 -> {
        var0.add(Items.BRICK);
        var0.add(Items.BRICK);
        var0.add(Items.BRICK);
        var0.add(Items.BRICK);
    });

    public DecoratedPotBlockEntity(BlockPosition var02, IBlockData var1) {
        super(TileEntityTypes.DECORATED_POT, var02, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        DecoratedPotBlockEntity.saveShards(this.shards, var0);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        if (var0.contains(TAG_SHARDS, 9)) {
            int var3;
            NBTTagList var1 = var0.getList(TAG_SHARDS, 8);
            this.shards.clear();
            int var2 = Math.min(4, var1.size());
            for (var3 = 0; var3 < var2; ++var3) {
                NBTBase nBTBase = var1.get(var3);
                if (nBTBase instanceof NBTTagString) {
                    NBTTagString var4 = (NBTTagString)nBTBase;
                    this.shards.add(BuiltInRegistries.ITEM.get(new MinecraftKey(var4.getAsString())));
                    continue;
                }
                this.shards.add(Items.BRICK);
            }
            var3 = 4 - var2;
            for (int var4 = 0; var4 < var3; ++var4) {
                this.shards.add(Items.BRICK);
            }
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public static void saveShards(List<Item> var0, NBTTagCompound var1) {
        NBTTagList var2 = new NBTTagList();
        for (Item var4 : var0) {
            var2.add(NBTTagString.valueOf(BuiltInRegistries.ITEM.getKey(var4).toString()));
        }
        var1.put(TAG_SHARDS, var2);
    }

    public ItemStack getItem() {
        ItemStack var0 = new ItemStack(Blocks.DECORATED_POT);
        NBTTagCompound var1 = new NBTTagCompound();
        DecoratedPotBlockEntity.saveShards(this.shards, var1);
        ItemBlock.setBlockEntityData(var0, TileEntityTypes.DECORATED_POT, var1);
        return var0;
    }

    public List<Item> getShards() {
        return this.shards;
    }

    public void playerDestroy(World var0, BlockPosition var1, ItemStack var2, EntityHuman var3) {
        if (var3.isCreative()) {
            this.isBroken = true;
            return;
        }
        if (var2.is(TagsItem.BREAKS_DECORATED_POTS) && !EnchantmentManager.hasSilkTouch(var2)) {
            List<Item> var4 = this.getShards();
            NonNullList<ItemStack> var5 = NonNullList.createWithCapacity(var4.size());
            var5.addAll(0, var4.stream().map(Item::getDefaultInstance).toList());
            InventoryUtils.dropContents(var0, var1, var5);
            this.isBroken = true;
            var0.playSound(null, var1, SoundEffects.DECORATED_POT_SHATTER, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    public EnumDirection getDirection() {
        return this.getBlockState().getValue(BlockProperties.HORIZONTAL_FACING);
    }

    public void setFromItem(ItemStack var0) {
        NBTTagCompound var1 = ItemBlock.getBlockEntityData(var0);
        if (var1 != null) {
            this.load(var1);
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

