/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.PointGroupO;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;

public final class EnumBlockRotation
extends Enum<EnumBlockRotation>
implements INamable {
    public static final /* enum */ EnumBlockRotation NONE = new EnumBlockRotation("none", PointGroupO.IDENTITY);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_90 = new EnumBlockRotation("clockwise_90", PointGroupO.ROT_90_Y_NEG);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_180 = new EnumBlockRotation("180", PointGroupO.ROT_180_FACE_XZ);
    public static final /* enum */ EnumBlockRotation COUNTERCLOCKWISE_90 = new EnumBlockRotation("counterclockwise_90", PointGroupO.ROT_90_Y_POS);
    public static final Codec<EnumBlockRotation> CODEC;
    private final String id;
    private final PointGroupO rotation;
    private static final /* synthetic */ EnumBlockRotation[] h;

    public static EnumBlockRotation[] values() {
        return (EnumBlockRotation[])h.clone();
    }

    public static EnumBlockRotation valueOf(String var0) {
        return Enum.valueOf(EnumBlockRotation.class, var0);
    }

    private EnumBlockRotation(String var2, PointGroupO var3) {
        this.id = var2;
        this.rotation = var3;
    }

    public EnumBlockRotation getRotated(EnumBlockRotation var0) {
        switch (var0) {
            case CLOCKWISE_180: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return NONE;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return NONE;
                    }
                    case CLOCKWISE_180: {
                        return CLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_180: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public PointGroupO rotation() {
        return this.rotation;
    }

    public EnumDirection rotate(EnumDirection var0) {
        if (var0.getAxis() == EnumDirection.EnumAxis.Y) {
            return var0;
        }
        switch (this) {
            case CLOCKWISE_180: {
                return var0.getOpposite();
            }
            case COUNTERCLOCKWISE_90: {
                return var0.getCounterClockWise();
            }
            case CLOCKWISE_90: {
                return var0.getClockWise();
            }
        }
        return var0;
    }

    public int rotate(int var0, int var1) {
        switch (this) {
            case CLOCKWISE_180: {
                return (var0 + var1 / 2) % var1;
            }
            case COUNTERCLOCKWISE_90: {
                return (var0 + var1 * 3 / 4) % var1;
            }
            case CLOCKWISE_90: {
                return (var0 + var1 / 4) % var1;
            }
        }
        return var0;
    }

    public static EnumBlockRotation getRandom(RandomSource var0) {
        return SystemUtils.getRandom(EnumBlockRotation.values(), var0);
    }

    public static List<EnumBlockRotation> getShuffled(RandomSource var0) {
        return SystemUtils.shuffledCopy(EnumBlockRotation.values(), var0);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    private static /* synthetic */ EnumBlockRotation[] b() {
        return new EnumBlockRotation[]{NONE, CLOCKWISE_90, CLOCKWISE_180, COUNTERCLOCKWISE_90};
    }

    static {
        h = EnumBlockRotation.b();
        CODEC = INamable.fromEnum(EnumBlockRotation::values);
    }
}

