/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.jetbrains.annotations.Nullable;

public class DecoratedPotBlock
extends BlockTileEntity {
    private static final VoxelShape BOUNDING_BOX = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection HORIZONTAL_FACING = BlockProperties.HORIZONTAL_FACING;
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;

    protected DecoratedPotBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HORIZONTAL_FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(HORIZONTAL_FACING, var0.getHorizontalDirection())).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return BOUNDING_BOX;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HORIZONTAL_FACING, WATERLOGGED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new DecoratedPotBlockEntity(var0, var1);
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        TileEntity tileEntity;
        if (!var0.isClientSide && (tileEntity = var0.getBlockEntity(var1)) instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity var4 = (DecoratedPotBlockEntity)tileEntity;
            var4.playerDestroy(var0, var1, var3.getMainHandItem(), var3);
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        DecoratedPotBlockEntity var6;
        TileEntity var5;
        if (!var1.isClientSide && (var5 = var1.getBlockEntity(var2)) instanceof DecoratedPotBlockEntity && !(var6 = (DecoratedPotBlockEntity)var5).isBroken()) {
            InventoryUtils.dropItemStack(var1, var2.getX(), var2.getY(), var2.getZ(), var6.getItem());
            var1.playSound(null, var2, SoundEffects.DECORATED_POT_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }
}

