/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;

public abstract class BlockSkullAbstract
extends BlockTileEntity
implements Equipable {
    private final BlockSkull.a type;

    public BlockSkullAbstract(BlockSkull.a var0, BlockBase.Info var1) {
        super(var1);
        this.type = var0;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySkull(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var0.isClientSide) {
            boolean var3;
            boolean bl = var3 = var1.is(Blocks.DRAGON_HEAD) || var1.is(Blocks.DRAGON_WALL_HEAD) || var1.is(Blocks.PIGLIN_HEAD) || var1.is(Blocks.PIGLIN_WALL_HEAD);
            if (var3) {
                return BlockSkullAbstract.createTickerHelper(var2, TileEntityTypes.SKULL, TileEntitySkull::animation);
            }
        }
        return null;
    }

    public BlockSkull.a getType() {
        return this.type;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return EnumItemSlot.HEAD;
    }
}

