/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    private static final float OPEN_AABB_SIZE = 1.0f;
    private static final VoxelShape UP_OPEN_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> OPEN_SHAPE_BY_DIRECTION = SystemUtils.make(Maps.newEnumMap(EnumDirection.class), var0 -> {
        var0.put(EnumDirection.NORTH, NORTH_OPEN_AABB);
        var0.put(EnumDirection.EAST, EAST_OPEN_AABB);
        var0.put(EnumDirection.SOUTH, SOUTH_OPEN_AABB);
        var0.put(EnumDirection.WEST, WES_OPEN_AABB);
        var0.put(EnumDirection.UP, UP_OPEN_AABB);
        var0.put(EnumDirection.DOWN, DOWN_OPEN_AABB);
    });
    public static final BlockStateEnum<EnumDirection> FACING = BlockDirectional.FACING;
    public static final MinecraftKey CONTENTS = new MinecraftKey("contents");
    @Nullable
    public final EnumColor color;

    public BlockShulkerBox(@Nullable EnumColor var0, BlockBase.Info var1) {
        super(var1);
        this.color = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.UP));
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityShulkerBox(this.color, var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockShulkerBox.createTickerHelper(var2, TileEntityTypes.SHULKER_BOX, TileEntityShulkerBox::tick);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        if (var3.isSpectator()) {
            return EnumInteractionResult.CONSUME;
        }
        TileEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var7 = (TileEntityShulkerBox)var6;
            if (BlockShulkerBox.canOpen(var0, var1, var2, var7)) {
                var3.openMenu(var7);
                var3.awardStat(StatisticList.OPEN_SHULKER_BOX);
                PiglinAI.angerNearbyPiglins(var3, true);
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    private static boolean canOpen(IBlockData var0, World var1, BlockPosition var2, TileEntityShulkerBox var3) {
        if (var3.getAnimationStatus() != TileEntityShulkerBox.AnimationPhase.CLOSED) {
            return true;
        }
        AxisAlignedBB var4 = EntityShulker.getProgressDeltaAabb(var0.getValue(FACING), 0.0f, 0.5f).move(var2).deflate(1.0E-6);
        return var1.noCollision(var4);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getClickedFace());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        TileEntity var4 = var0.getBlockEntity(var1);
        if (var4 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var5 = (TileEntityShulkerBox)var4;
            if (!var0.isClientSide && var3.isCreative() && !var5.isEmpty()) {
                ItemStack var6 = BlockShulkerBox.getColoredItemStack(this.getColor());
                var4.saveToItem(var6);
                if (var5.hasCustomName()) {
                    var6.setHoverName(var5.getCustomName());
                }
                EntityItem var7 = new EntityItem(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var6);
                var7.setDefaultPickUpDelay();
                var0.addFreshEntity(var7);
            } else {
                var5.unpackLootTable(var3);
            }
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public List<ItemStack> getDrops(IBlockData var0, LootTableInfo.Builder var12) {
        TileEntity var22 = var12.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
        if (var22 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var3 = (TileEntityShulkerBox)var22;
            var12 = var12.withDynamicDrop(CONTENTS, (var1, var2) -> {
                for (int var3 = 0; var3 < var3.getContainerSize(); ++var3) {
                    var2.accept(var3.getItem(var3));
                }
            });
        }
        return super.getDrops(var0, var12);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        TileEntity var5;
        if (var4.hasCustomHoverName() && (var5 = var0.getBlockEntity(var1)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)var5).setCustomName(var4.getHoverName());
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityShulkerBox) {
            var1.updateNeighbourForOutputSignal(var2, var0.getBlock());
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable IBlockAccess var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        NBTTagCompound var4 = ItemBlock.getBlockEntityData(var0);
        if (var4 != null) {
            if (var4.contains("LootTable", 8)) {
                var2.add(IChatBaseComponent.literal("???????"));
            }
            if (var4.contains("Items", 9)) {
                NonNullList<ItemStack> var5 = NonNullList.withSize(27, ItemStack.EMPTY);
                ContainerUtil.loadAllItems(var4, var5);
                int var6 = 0;
                int var7 = 0;
                for (ItemStack var9 : var5) {
                    if (var9.isEmpty()) continue;
                    ++var7;
                    if (var6 > 4) continue;
                    ++var6;
                    IChatMutableComponent var10 = var9.getHoverName().copy();
                    var10.append(" x").append(String.valueOf(var9.getCount()));
                    var2.add(var10);
                }
                if (var7 - var6 > 0) {
                    var2.add(IChatBaseComponent.translatable("container.shulkerBox.more", var7 - var6).withStyle(EnumChatFormat.ITALIC));
                }
            }
        }
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.DESTROY;
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        TileEntityShulkerBox var4;
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof TileEntityShulkerBox && !(var4 = (TileEntityShulkerBox)var3).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get(var0.getValue(FACING).getOpposite());
        }
        return VoxelShapes.block();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityShulkerBox) {
            return VoxelShapes.create(((TileEntityShulkerBox)var4).getBoundingBox(var0));
        }
        return VoxelShapes.block();
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return Container.getRedstoneSignalFromContainer((IInventory)((Object)var1.getBlockEntity(var2)));
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var12, IBlockData var2) {
        ItemStack var3 = super.getCloneItemStack(var0, var12, var2);
        var0.getBlockEntity(var12, TileEntityTypes.SHULKER_BOX).ifPresent(var1 -> var1.saveToItem(var3));
        return var3;
    }

    @Nullable
    public static EnumColor getColorFromItem(Item var0) {
        return BlockShulkerBox.getColorFromBlock(Block.byItem(var0));
    }

    @Nullable
    public static EnumColor getColorFromBlock(Block var0) {
        if (var0 instanceof BlockShulkerBox) {
            return ((BlockShulkerBox)var0).getColor();
        }
        return null;
    }

    public static Block getBlockByColor(@Nullable EnumColor var0) {
        if (var0 == null) {
            return Blocks.SHULKER_BOX;
        }
        switch (var0) {
            case WHITE: {
                return Blocks.WHITE_SHULKER_BOX;
            }
            case ORANGE: {
                return Blocks.ORANGE_SHULKER_BOX;
            }
            case MAGENTA: {
                return Blocks.MAGENTA_SHULKER_BOX;
            }
            case LIGHT_BLUE: {
                return Blocks.LIGHT_BLUE_SHULKER_BOX;
            }
            case YELLOW: {
                return Blocks.YELLOW_SHULKER_BOX;
            }
            case LIME: {
                return Blocks.LIME_SHULKER_BOX;
            }
            case PINK: {
                return Blocks.PINK_SHULKER_BOX;
            }
            case GRAY: {
                return Blocks.GRAY_SHULKER_BOX;
            }
            case LIGHT_GRAY: {
                return Blocks.LIGHT_GRAY_SHULKER_BOX;
            }
            case CYAN: {
                return Blocks.CYAN_SHULKER_BOX;
            }
            default: {
                return Blocks.PURPLE_SHULKER_BOX;
            }
            case BLUE: {
                return Blocks.BLUE_SHULKER_BOX;
            }
            case BROWN: {
                return Blocks.BROWN_SHULKER_BOX;
            }
            case GREEN: {
                return Blocks.GREEN_SHULKER_BOX;
            }
            case RED: {
                return Blocks.RED_SHULKER_BOX;
            }
            case BLACK: 
        }
        return Blocks.BLACK_SHULKER_BOX;
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable EnumColor var0) {
        return new ItemStack(BlockShulkerBox.getBlockByColor(var0));
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }
}

