/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockSeaPickle
extends BlockPlant
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    public static final int MAX_PICKLES = 4;
    public static final BlockStateInteger PICKLES = BlockProperties.PICKLES;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final VoxelShape ONE_AABB = Block.box(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
    protected static final VoxelShape TWO_AABB = Block.box(3.0, 0.0, 3.0, 13.0, 6.0, 13.0);
    protected static final VoxelShape THREE_AABB = Block.box(2.0, 0.0, 2.0, 14.0, 6.0, 14.0);
    protected static final VoxelShape FOUR_AABB = Block.box(2.0, 0.0, 2.0, 14.0, 7.0, 14.0);

    protected BlockSeaPickle(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(PICKLES, 1)).setValue(WATERLOGGED, true));
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (IBlockData)var1.setValue(PICKLES, Math.min(4, var1.getValue(PICKLES) + 1));
        }
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var2.getType() == FluidTypes.WATER;
        return (IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var3);
    }

    public static boolean isDead(IBlockData var0) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return !var0.getCollisionShape(var1, var2).getFaceShape(EnumDirection.UP).isEmpty() || var0.isFaceSturdy(var1, var2, EnumDirection.UP);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        return this.mayPlaceOn(var1.getBlockState(var3), var1, var3);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().is(this.asItem()) && var0.getValue(PICKLES) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(PICKLES)) {
            default: {
                return ONE_AABB;
            }
            case 2: {
                return TWO_AABB;
            }
            case 3: {
                return THREE_AABB;
            }
            case 4: 
        }
        return FOUR_AABB;
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(PICKLES, WATERLOGGED);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        if (!BlockSeaPickle.isDead(var3) && var0.getBlockState(var2.below()).is(TagsBlock.CORAL_BLOCKS)) {
            int var4 = 5;
            int var5 = 1;
            int var6 = 2;
            int var7 = 0;
            int var8 = var2.getX() - 2;
            int var9 = 0;
            for (int var10 = 0; var10 < 5; ++var10) {
                for (int var11 = 0; var11 < var5; ++var11) {
                    int var12 = 2 + var2.getY() - 1;
                    for (int var13 = var12 - 2; var13 < var12; ++var13) {
                        IBlockData var15;
                        BlockPosition var14 = new BlockPosition(var8 + var10, var13, var2.getZ() - var9 + var11);
                        if (var14 == var2 || var1.nextInt(6) != 0 || !var0.getBlockState(var14).is(Blocks.WATER) || !(var15 = var0.getBlockState(var14.below())).is(TagsBlock.CORAL_BLOCKS)) continue;
                        var0.setBlock(var14, (IBlockData)Blocks.SEA_PICKLE.defaultBlockState().setValue(PICKLES, var1.nextInt(4) + 1), 3);
                    }
                }
                if (var7 < 2) {
                    var5 += 2;
                    ++var9;
                } else {
                    var5 -= 2;
                    --var9;
                }
                ++var7;
            }
            var0.setBlock(var2, (IBlockData)var3.setValue(PICKLES, 4), 2);
        }
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

