/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockSapling
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final BlockStateInteger STAGE = BlockProperties.STAGE;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 12.0, 14.0);
    private final WorldGenTreeProvider treeGrower;

    protected BlockSapling(WorldGenTreeProvider var0, BlockBase.Info var1) {
        super(var1);
        this.treeGrower = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(STAGE, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.getMaxLocalRawBrightness(var2.above()) >= 9 && var3.nextInt(7) == 0) {
            this.advanceTree(var1, var2, var0, var3);
        }
    }

    public void advanceTree(WorldServer var0, BlockPosition var1, IBlockData var2, RandomSource var3) {
        if (var2.getValue(STAGE) == 0) {
            var0.setBlock(var1, (IBlockData)var2.cycle(STAGE), 4);
        } else {
            this.treeGrower.growTree(var0, var0.getChunkSource().getGenerator(), var1, var2, var3);
        }
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return (double)var0.random.nextFloat() < 0.45;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.advanceTree(var0, var2, var3, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(STAGE);
    }
}

