/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    private final int maxWeight;

    protected BlockPressurePlateWeighted(int var0, BlockBase.Info var1, BlockSetType var2) {
        super(var1, var2);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWER, 0));
        this.maxWeight = var0;
    }

    @Override
    protected int getSignalStrength(World var0, BlockPosition var1) {
        int var2 = Math.min(var0.getEntitiesOfClass(Entity.class, TOUCH_AABB.move(var1)).size(), this.maxWeight);
        if (var2 > 0) {
            float var3 = (float)Math.min(this.maxWeight, var2) / (float)this.maxWeight;
            return MathHelper.ceil(var3 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int getSignalForState(IBlockData var0) {
        return var0.getValue(POWER);
    }

    @Override
    protected IBlockData setSignalForState(IBlockData var0, int var1) {
        return (IBlockData)var0.setValue(POWER, var1);
    }

    @Override
    protected int getPressedTime() {
        return 10;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWER);
    }
}

