/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    private static final MapCodec<Holder<BiomeBase>> ENTRY_CODEC = BiomeBase.CODEC.fieldOf("biome");
    public static final MapCodec<Climate.c<Holder<BiomeBase>>> DIRECT_CODEC = Climate.c.codec(ENTRY_CODEC).fieldOf("biomes");
    private static final MapCodec<Holder<MultiNoiseBiomeSourceParameterList>> PRESET_CODEC = MultiNoiseBiomeSourceParameterList.CODEC.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final Codec<WorldChunkManagerMultiNoise> CODEC = Codec.mapEither(DIRECT_CODEC, PRESET_CODEC).xmap(WorldChunkManagerMultiNoise::new, var0 -> var0.parameters).codec();
    private final Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> parameters;

    private WorldChunkManagerMultiNoise(Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> var0) {
        this.parameters = var0;
    }

    public static WorldChunkManagerMultiNoise createFromList(Climate.c<Holder<BiomeBase>> var0) {
        return new WorldChunkManagerMultiNoise((Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.left(var0));
    }

    public static WorldChunkManagerMultiNoise createFromPreset(Holder<MultiNoiseBiomeSourceParameterList> var0) {
        return new WorldChunkManagerMultiNoise((Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.right(var0));
    }

    private Climate.c<Holder<BiomeBase>> parameters() {
        return (Climate.c)this.parameters.map(var0 -> var0, var0 -> ((MultiNoiseBiomeSourceParameterList)var0.value()).parameters());
    }

    @Override
    protected Stream<Holder<BiomeBase>> collectPossibleBiomes() {
        return this.parameters().values().stream().map(Pair::getSecond);
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    public boolean stable(ResourceKey<MultiNoiseBiomeSourceParameterList> var0) {
        Optional var1 = this.parameters.right();
        return var1.isPresent() && ((Holder)var1.get()).is(var0);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.getNoiseBiome(var3.sample(var0, var1, var2));
    }

    @VisibleForDebug
    public Holder<BiomeBase> getNoiseBiome(Climate.h var0) {
        return this.parameters().findValue(var0);
    }

    @Override
    public void addDebugInfo(List<String> var0, BlockPosition var1, Climate.Sampler var2) {
        int var3 = QuartPos.fromBlock(var1.getX());
        int var4 = QuartPos.fromBlock(var1.getY());
        int var5 = QuartPos.fromBlock(var1.getZ());
        Climate.h var6 = var2.sample(var3, var4, var5);
        float var7 = Climate.unquantizeCoord(var6.continentalness());
        float var8 = Climate.unquantizeCoord(var6.erosion());
        float var9 = Climate.unquantizeCoord(var6.temperature());
        float var10 = Climate.unquantizeCoord(var6.humidity());
        float var11 = Climate.unquantizeCoord(var6.weirdness());
        double var12 = NoiseRouterData.peaksAndValleys(var11);
        OverworldBiomeBuilder var14 = new OverworldBiomeBuilder();
        var0.add("Biome builder PV: " + OverworldBiomeBuilder.getDebugStringForPeaksAndValleys(var12) + " C: " + var14.getDebugStringForContinentalness(var7) + " E: " + var14.getDebugStringForErosion(var8) + " T: " + var14.getDebugStringForTemperature(var9) + " H: " + var14.getDebugStringForHumidity(var10));
    }
}

