/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class MultiNoiseBiomeSourceParameterList {
    public static final Codec<MultiNoiseBiomeSourceParameterList> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)a.CODEC.fieldOf("preset").forGetter(var0 -> var0.preset), RegistryOps.retrieveGetter(Registries.BIOME)).apply((Applicative)var02, MultiNoiseBiomeSourceParameterList::new));
    public static final Codec<Holder<MultiNoiseBiomeSourceParameterList>> CODEC = RegistryFileCodec.create(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DIRECT_CODEC);
    private final a preset;
    private final Climate.c<Holder<BiomeBase>> parameters;

    public MultiNoiseBiomeSourceParameterList(a var0, HolderGetter<BiomeBase> var1) {
        this.preset = var0;
        this.parameters = var0.provider.apply(var1::getOrThrow);
    }

    public Climate.c<Holder<BiomeBase>> parameters() {
        return this.parameters;
    }

    public static Map<a, Climate.c<ResourceKey<BiomeBase>>> knownPresets() {
        return a.BY_NAME.values().stream().collect(Collectors.toMap(var0 -> var0, var02 -> var02.provider().apply(var0 -> var0)));
    }

    public static final class net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a
    extends Record {
        private final MinecraftKey id;
        final a provider;
        public static final net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a NETHER = new net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a(new MinecraftKey("nether"), new a(){

            @Override
            public <T> Climate.c<T> apply(Function<ResourceKey<BiomeBase>, T> var0) {
                return new Climate.c(List.of(Pair.of((Object)Climate.parameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.NETHER_WASTES)), Pair.of((Object)Climate.parameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Climate.parameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), var0.apply(Biomes.CRIMSON_FOREST)), Pair.of((Object)Climate.parameters(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), var0.apply(Biomes.WARPED_FOREST)), Pair.of((Object)Climate.parameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), var0.apply(Biomes.BASALT_DELTAS))));
            }
        });
        public static final net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a OVERWORLD = new net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a(new MinecraftKey("overworld"), new a(){

            @Override
            public <T> Climate.c<T> apply(Function<ResourceKey<BiomeBase>, T> var0) {
                return net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a.generateOverworldBiomes(var0, OverworldBiomeBuilder.a.NONE);
            }
        });
        public static final net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a OVERWORLD_UPDATE_1_20 = new net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a(new MinecraftKey("overworld_update_1_20"), new a(){

            @Override
            public <T> Climate.c<T> apply(Function<ResourceKey<BiomeBase>, T> var0) {
                return net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a.generateOverworldBiomes(var0, OverworldBiomeBuilder.a.UPDATE_1_20);
            }
        });
        static final Map<MinecraftKey, net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a> BY_NAME = Stream.of(NETHER, OVERWORLD, OVERWORLD_UPDATE_1_20).collect(Collectors.toMap(net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a::id, var0 -> var0));
        public static final Codec<net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a> CODEC = MinecraftKey.CODEC.flatXmap(var0 -> Optional.ofNullable(BY_NAME.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown preset: " + var0)), var0 -> DataResult.success((Object)var0.id));

        public net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a(MinecraftKey var0, a var1) {
            this.id = var0;
            this.provider = var1;
        }

        static <T> Climate.c<T> generateOverworldBiomes(Function<ResourceKey<BiomeBase>, T> var0, OverworldBiomeBuilder.a var1) {
            ImmutableList.Builder var22 = ImmutableList.builder();
            new OverworldBiomeBuilder(var1).addBiomes(var2 -> var22.add((Object)var2.mapSecond(var0)));
            return new Climate.c(var22.build());
        }

        public Stream<ResourceKey<BiomeBase>> usedBiomes() {
            return this.provider.apply(var0 -> var0).values().stream().map(Pair::getSecond).distinct();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a.class, "id;provider", "id", "provider"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a.class, "id;provider", "id", "provider"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$a.class, "id;provider", "id", "provider"}, this, var0);
        }

        public MinecraftKey id() {
            return this.id;
        }

        public a provider() {
            return this.provider;
        }

        @FunctionalInterface
        static interface a {
            public <T> Climate.c<T> apply(Function<ResourceKey<BiomeBase>, T> var1);
        }
    }
}

