/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;

public class SmithingTrimRecipe
implements SmithingRecipe {
    private final MinecraftKey id;
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;

    public SmithingTrimRecipe(MinecraftKey var0, RecipeItemStack var1, RecipeItemStack var2, RecipeItemStack var3) {
        this.id = var0;
        this.template = var1;
        this.base = var2;
        this.addition = var3;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.template.test(var0.getItem(0)) && this.base.test(var0.getItem(1)) && this.addition.test(var0.getItem(2));
    }

    @Override
    public ItemStack assemble(IInventory var0, IRegistryCustom var1) {
        ItemStack var2 = var0.getItem(1);
        if (this.base.test(var2)) {
            Optional<Holder.c<TrimMaterial>> var3 = TrimMaterials.getFromIngredient(var1, var0.getItem(2));
            Optional<Holder.c<TrimPattern>> var4 = TrimPatterns.getFromTemplate(var1, var0.getItem(0));
            if (var3.isPresent() && var4.isPresent()) {
                Optional<ArmorTrim> var5 = ArmorTrim.getTrim(var1, var2);
                if (var5.isPresent() && var5.get().hasPatternAndMaterial((Holder<TrimPattern>)var4.get(), (Holder<TrimMaterial>)var3.get())) {
                    return ItemStack.EMPTY;
                }
                ItemStack var6 = var2.copy();
                var6.setCount(1);
                ArmorTrim var7 = new ArmorTrim((Holder<TrimMaterial>)var3.get(), (Holder<TrimPattern>)var4.get());
                if (ArmorTrim.setTrim(var1, var6, var7)) {
                    return var6;
                }
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        Optional<Holder.c<TrimMaterial>> var3;
        ItemStack var1 = new ItemStack(Items.IRON_CHESTPLATE);
        Optional<Holder.c<TrimPattern>> var2 = var0.registryOrThrow(Registries.TRIM_PATTERN).holders().findFirst();
        if (var2.isPresent() && (var3 = var0.registryOrThrow(Registries.TRIM_MATERIAL).getHolder(TrimMaterials.REDSTONE)).isPresent()) {
            ArmorTrim var4 = new ArmorTrim((Holder<TrimMaterial>)var3.get(), (Holder<TrimPattern>)var2.get());
            ArmorTrim.setTrim(var0, var1, var4);
        }
        return var1;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack var0) {
        return this.template.test(var0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack var0) {
        return this.base.test(var0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        @Override
        public SmithingTrimRecipe fromJson(MinecraftKey var0, JsonObject var1) {
            RecipeItemStack var2 = RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "template"));
            RecipeItemStack var3 = RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "base"));
            RecipeItemStack var4 = RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "addition"));
            return new SmithingTrimRecipe(var0, var2, var3, var4);
        }

        @Override
        public SmithingTrimRecipe fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            RecipeItemStack var2 = RecipeItemStack.fromNetwork(var1);
            RecipeItemStack var3 = RecipeItemStack.fromNetwork(var1);
            RecipeItemStack var4 = RecipeItemStack.fromNetwork(var1);
            return new SmithingTrimRecipe(var0, var2, var3, var4);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, SmithingTrimRecipe var1) {
            var1.template.toNetwork(var0);
            var1.base.toNetwork(var0);
            var1.addition.toNetwork(var0);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }
    }
}

