/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class RecipiesShield
extends IRecipeComplex {
    public RecipiesShield(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        ItemStack var2 = ItemStack.EMPTY;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof ItemBanner) {
                if (!var3.isEmpty()) {
                    return false;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.SHIELD)) {
                if (!var2.isEmpty()) {
                    return false;
                }
                if (ItemBlock.getBlockEntityData(var5) != null) {
                    return false;
                }
                var2 = var5;
                continue;
            }
            return false;
        }
        return !var2.isEmpty() && !var3.isEmpty();
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        Object var5;
        Object var2 = ItemStack.EMPTY;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            var5 = var0.getItem(var4);
            if (((ItemStack)var5).isEmpty()) continue;
            if (((ItemStack)var5).getItem() instanceof ItemBanner) {
                var2 = var5;
                continue;
            }
            if (!((ItemStack)var5).is(Items.SHIELD)) continue;
            var3 = ((ItemStack)var5).copy();
        }
        if (var3.isEmpty()) {
            return var3;
        }
        NBTTagCompound var4 = ItemBlock.getBlockEntityData((ItemStack)var2);
        var5 = var4 == null ? new NBTTagCompound() : var4.copy();
        ((NBTTagCompound)var5).putInt("Base", ((ItemBanner)((ItemStack)var2).getItem()).getColor().getId());
        ItemBlock.setBlockEntityData(var3, TileEntityTypes.BANNER, (NBTTagCompound)var5);
        return var3;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHIELD_DECORATION;
    }
}

