/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonObject;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.DecoratedPotRecipe;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.LegacyUpgradeRecipe;
import net.minecraft.world.item.crafting.RecipeArmorDye;
import net.minecraft.world.item.crafting.RecipeBannerDuplicate;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeBookClone;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeFireworks;
import net.minecraft.world.item.crafting.RecipeFireworksFade;
import net.minecraft.world.item.crafting.RecipeFireworksStar;
import net.minecraft.world.item.crafting.RecipeMapClone;
import net.minecraft.world.item.crafting.RecipeMapExtend;
import net.minecraft.world.item.crafting.RecipeRepair;
import net.minecraft.world.item.crafting.RecipeSerializerCooking;
import net.minecraft.world.item.crafting.RecipeShulkerBox;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.RecipeSuspiciousStew;
import net.minecraft.world.item.crafting.RecipeTippedArrow;
import net.minecraft.world.item.crafting.RecipiesShield;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;

public interface RecipeSerializer<T extends IRecipe<?>> {
    public static final RecipeSerializer<ShapedRecipes> SHAPED_RECIPE = RecipeSerializer.register("crafting_shaped", new ShapedRecipes.a());
    public static final RecipeSerializer<ShapelessRecipes> SHAPELESS_RECIPE = RecipeSerializer.register("crafting_shapeless", new ShapelessRecipes.a());
    public static final RecipeSerializer<RecipeArmorDye> ARMOR_DYE = RecipeSerializer.register("crafting_special_armordye", new SimpleCraftingRecipeSerializer<RecipeArmorDye>(RecipeArmorDye::new));
    public static final RecipeSerializer<RecipeBookClone> BOOK_CLONING = RecipeSerializer.register("crafting_special_bookcloning", new SimpleCraftingRecipeSerializer<RecipeBookClone>(RecipeBookClone::new));
    public static final RecipeSerializer<RecipeMapClone> MAP_CLONING = RecipeSerializer.register("crafting_special_mapcloning", new SimpleCraftingRecipeSerializer<RecipeMapClone>(RecipeMapClone::new));
    public static final RecipeSerializer<RecipeMapExtend> MAP_EXTENDING = RecipeSerializer.register("crafting_special_mapextending", new SimpleCraftingRecipeSerializer<RecipeMapExtend>(RecipeMapExtend::new));
    public static final RecipeSerializer<RecipeFireworks> FIREWORK_ROCKET = RecipeSerializer.register("crafting_special_firework_rocket", new SimpleCraftingRecipeSerializer<RecipeFireworks>(RecipeFireworks::new));
    public static final RecipeSerializer<RecipeFireworksStar> FIREWORK_STAR = RecipeSerializer.register("crafting_special_firework_star", new SimpleCraftingRecipeSerializer<RecipeFireworksStar>(RecipeFireworksStar::new));
    public static final RecipeSerializer<RecipeFireworksFade> FIREWORK_STAR_FADE = RecipeSerializer.register("crafting_special_firework_star_fade", new SimpleCraftingRecipeSerializer<RecipeFireworksFade>(RecipeFireworksFade::new));
    public static final RecipeSerializer<RecipeTippedArrow> TIPPED_ARROW = RecipeSerializer.register("crafting_special_tippedarrow", new SimpleCraftingRecipeSerializer<RecipeTippedArrow>(RecipeTippedArrow::new));
    public static final RecipeSerializer<RecipeBannerDuplicate> BANNER_DUPLICATE = RecipeSerializer.register("crafting_special_bannerduplicate", new SimpleCraftingRecipeSerializer<RecipeBannerDuplicate>(RecipeBannerDuplicate::new));
    public static final RecipeSerializer<RecipiesShield> SHIELD_DECORATION = RecipeSerializer.register("crafting_special_shielddecoration", new SimpleCraftingRecipeSerializer<RecipiesShield>(RecipiesShield::new));
    public static final RecipeSerializer<RecipeShulkerBox> SHULKER_BOX_COLORING = RecipeSerializer.register("crafting_special_shulkerboxcoloring", new SimpleCraftingRecipeSerializer<RecipeShulkerBox>(RecipeShulkerBox::new));
    public static final RecipeSerializer<RecipeSuspiciousStew> SUSPICIOUS_STEW = RecipeSerializer.register("crafting_special_suspiciousstew", new SimpleCraftingRecipeSerializer<RecipeSuspiciousStew>(RecipeSuspiciousStew::new));
    public static final RecipeSerializer<RecipeRepair> REPAIR_ITEM = RecipeSerializer.register("crafting_special_repairitem", new SimpleCraftingRecipeSerializer<RecipeRepair>(RecipeRepair::new));
    public static final RecipeSerializer<FurnaceRecipe> SMELTING_RECIPE = RecipeSerializer.register("smelting", new RecipeSerializerCooking<FurnaceRecipe>(FurnaceRecipe::new, 200));
    public static final RecipeSerializer<RecipeBlasting> BLASTING_RECIPE = RecipeSerializer.register("blasting", new RecipeSerializerCooking<RecipeBlasting>(RecipeBlasting::new, 100));
    public static final RecipeSerializer<RecipeSmoking> SMOKING_RECIPE = RecipeSerializer.register("smoking", new RecipeSerializerCooking<RecipeSmoking>(RecipeSmoking::new, 100));
    public static final RecipeSerializer<RecipeCampfire> CAMPFIRE_COOKING_RECIPE = RecipeSerializer.register("campfire_cooking", new RecipeSerializerCooking<RecipeCampfire>(RecipeCampfire::new, 100));
    public static final RecipeSerializer<RecipeStonecutting> STONECUTTER = RecipeSerializer.register("stonecutting", new RecipeSingleItem.a<RecipeStonecutting>(RecipeStonecutting::new));
    public static final RecipeSerializer<LegacyUpgradeRecipe> SMITHING = RecipeSerializer.register("smithing", new LegacyUpgradeRecipe.a());
    public static final RecipeSerializer<SmithingTransformRecipe> SMITHING_TRANSFORM = RecipeSerializer.register("smithing_transform", new SmithingTransformRecipe.a());
    public static final RecipeSerializer<SmithingTrimRecipe> SMITHING_TRIM = RecipeSerializer.register("smithing_trim", new SmithingTrimRecipe.a());
    public static final RecipeSerializer<DecoratedPotRecipe> DECORATED_POT_RECIPE = RecipeSerializer.register("crafting_decorated_pot", new SimpleCraftingRecipeSerializer<DecoratedPotRecipe>(DecoratedPotRecipe::new));

    public T fromJson(MinecraftKey var1, JsonObject var2);

    public T fromNetwork(MinecraftKey var1, PacketDataSerializer var2);

    public void toNetwork(PacketDataSerializer var1, T var2);

    public static <S extends RecipeSerializer<T>, T extends IRecipe<?>> S register(String var0, S var1) {
        return (S)IRegistry.register(BuiltInRegistries.RECIPE_SERIALIZER, var0, var1);
    }
}

