/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class RecipeMapExtend
extends ShapedRecipes {
    public RecipeMapExtend(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, "", var1, 3, 3, NonNullList.of(RecipeItemStack.EMPTY, new RecipeItemStack[]{RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.FILLED_MAP), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER), RecipeItemStack.of(Items.PAPER)}), new ItemStack(Items.MAP));
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        if (!super.matches(var0, var1)) {
            return false;
        }
        ItemStack var2 = ItemStack.EMPTY;
        for (int var3 = 0; var3 < var0.getContainerSize() && var2.isEmpty(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (!var4.is(Items.FILLED_MAP)) continue;
            var2 = var4;
        }
        if (var2.isEmpty()) {
            return false;
        }
        WorldMap var3 = ItemWorldMap.getSavedData(var2, var1);
        if (var3 == null) {
            return false;
        }
        if (var3.isExplorationMap()) {
            return false;
        }
        return var3.scale < 4;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        ItemStack var2 = ItemStack.EMPTY;
        for (int var3 = 0; var3 < var0.getContainerSize() && var2.isEmpty(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (!var4.is(Items.FILLED_MAP)) continue;
            var2 = var4;
        }
        var2 = var2.copy();
        var2.setCount(1);
        var2.getOrCreateTag().putInt("map_scale_direction", 1);
        return var2;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.MAP_EXTENDING;
    }
}

