/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeBookClone
extends IRecipeComplex {
    public RecipeBookClone(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        int var2 = 0;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(Items.WRITTEN_BOOK)) {
                if (!var3.isEmpty()) {
                    return false;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.WRITABLE_BOOK)) {
                ++var2;
                continue;
            }
            return false;
        }
        return !var3.isEmpty() && var3.hasTag() && var2 > 0;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        Object var5;
        int var2 = 0;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            var5 = var0.getItem(var4);
            if (((ItemStack)var5).isEmpty()) continue;
            if (((ItemStack)var5).is(Items.WRITTEN_BOOK)) {
                if (!var3.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                var3 = var5;
                continue;
            }
            if (((ItemStack)var5).is(Items.WRITABLE_BOOK)) {
                ++var2;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (var3.isEmpty() || !var3.hasTag() || var2 < 1 || ItemWrittenBook.getGeneration(var3) >= 2) {
            return ItemStack.EMPTY;
        }
        ItemStack var4 = new ItemStack(Items.WRITTEN_BOOK, var2);
        var5 = var3.getTag().copy();
        ((NBTTagCompound)var5).putInt("generation", ItemWrittenBook.getGeneration(var3) + 1);
        var4.setTag((NBTTagCompound)var5);
        return var4;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting var0) {
        NonNullList<ItemStack> var1 = NonNullList.withSize(var0.getContainerSize(), ItemStack.EMPTY);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            if (var3.getItem().hasCraftingRemainingItem()) {
                var1.set(var2, new ItemStack(var3.getItem().getCraftingRemainingItem()));
                continue;
            }
            if (!(var3.getItem() instanceof ItemWrittenBook)) continue;
            ItemStack var4 = var3.copy();
            var4.setCount(1);
            var1.set(var2, var4);
            break;
        }
        return var1;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.BOOK_CLONING;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= 3 && var1 >= 3;
    }
}

