/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.List;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class DecoratedPotRecipe
extends IRecipeComplex {
    public DecoratedPotRecipe(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        if (!this.canCraftInDimensions(var0.getWidth(), var0.getHeight())) {
            return false;
        }
        block3: for (int var2 = 0; var2 < var0.getContainerSize(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            switch (var2) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    if (var3.is(TagsItem.DECORATED_POT_SHARDS)) continue block3;
                    return false;
                }
                default: {
                    if (var3.is(Items.AIR)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        ItemStack var2 = Items.DECORATED_POT.getDefaultInstance();
        NBTTagCompound var3 = new NBTTagCompound();
        DecoratedPotBlockEntity.saveShards(List.of(var0.getItem(1).getItem(), var0.getItem(3).getItem(), var0.getItem(5).getItem(), var0.getItem(7).getItem()), var3);
        ItemBlock.setBlockEntityData(var2, TileEntityTypes.DECORATED_POT, var3);
        return var2;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 == 3 && var1 == 3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.DECORATED_POT_RECIPE;
    }
}

