/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimPattern;

public class TrimPatterns {
    public static final ResourceKey<TrimPattern> SENTRY = TrimPatterns.registryKey("sentry");
    public static final ResourceKey<TrimPattern> DUNE = TrimPatterns.registryKey("dune");
    public static final ResourceKey<TrimPattern> COAST = TrimPatterns.registryKey("coast");
    public static final ResourceKey<TrimPattern> WILD = TrimPatterns.registryKey("wild");
    public static final ResourceKey<TrimPattern> WARD = TrimPatterns.registryKey("ward");
    public static final ResourceKey<TrimPattern> EYE = TrimPatterns.registryKey("eye");
    public static final ResourceKey<TrimPattern> VEX = TrimPatterns.registryKey("vex");
    public static final ResourceKey<TrimPattern> TIDE = TrimPatterns.registryKey("tide");
    public static final ResourceKey<TrimPattern> SNOUT = TrimPatterns.registryKey("snout");
    public static final ResourceKey<TrimPattern> RIB = TrimPatterns.registryKey("rib");
    public static final ResourceKey<TrimPattern> SPIRE = TrimPatterns.registryKey("spire");

    public static void bootstrap(BootstapContext<TrimPattern> var0) {
    }

    public static void nextUpdate(BootstapContext<TrimPattern> var0) {
        TrimPatterns.register(var0, Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, SENTRY);
        TrimPatterns.register(var0, Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, DUNE);
        TrimPatterns.register(var0, Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, COAST);
        TrimPatterns.register(var0, Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, WILD);
        TrimPatterns.register(var0, Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, WARD);
        TrimPatterns.register(var0, Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, EYE);
        TrimPatterns.register(var0, Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, VEX);
        TrimPatterns.register(var0, Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, TIDE);
        TrimPatterns.register(var0, Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, SNOUT);
        TrimPatterns.register(var0, Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, RIB);
        TrimPatterns.register(var0, Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, SPIRE);
    }

    public static Optional<Holder.c<TrimPattern>> getFromTemplate(IRegistryCustom var0, ItemStack var12) {
        return var0.registryOrThrow(Registries.TRIM_PATTERN).holders().filter(var1 -> var12.is(((TrimPattern)var1.value()).templateItem())).findFirst();
    }

    private static void register(BootstapContext<TrimPattern> var0, Item var1, ResourceKey<TrimPattern> var2) {
        TrimPattern var3 = new TrimPattern(var2.location(), BuiltInRegistries.ITEM.wrapAsHolder(var1), IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("trim_pattern", var2.location())));
        var0.register(var2, var3);
    }

    private static ResourceKey<TrimPattern> registryKey(String var0) {
        return ResourceKey.create(Registries.TRIM_PATTERN, new MinecraftKey(var0));
    }
}

