/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TrimMaterials {
    public static final ResourceKey<TrimMaterial> QUARTZ = TrimMaterials.registryKey("quartz");
    public static final ResourceKey<TrimMaterial> IRON = TrimMaterials.registryKey("iron");
    public static final ResourceKey<TrimMaterial> NETHERITE = TrimMaterials.registryKey("netherite");
    public static final ResourceKey<TrimMaterial> REDSTONE = TrimMaterials.registryKey("redstone");
    public static final ResourceKey<TrimMaterial> COPPER = TrimMaterials.registryKey("copper");
    public static final ResourceKey<TrimMaterial> GOLD = TrimMaterials.registryKey("gold");
    public static final ResourceKey<TrimMaterial> EMERALD = TrimMaterials.registryKey("emerald");
    public static final ResourceKey<TrimMaterial> DIAMOND = TrimMaterials.registryKey("diamond");
    public static final ResourceKey<TrimMaterial> LAPIS = TrimMaterials.registryKey("lapis");
    public static final ResourceKey<TrimMaterial> AMETHYST = TrimMaterials.registryKey("amethyst");

    public static void bootstrap(BootstapContext<TrimMaterial> var0) {
    }

    public static void nextUpdate(BootstapContext<TrimMaterial> var0) {
        TrimMaterials.register(var0, QUARTZ, Items.QUARTZ, ChatModifier.EMPTY.withColor(14931140), 0.1f);
        TrimMaterials.register(var0, IRON, Items.IRON_INGOT, ChatModifier.EMPTY.withColor(0xECECEC), 0.2f, Map.of(EnumArmorMaterial.IRON, "iron_darker"));
        TrimMaterials.register(var0, NETHERITE, Items.NETHERITE_INGOT, ChatModifier.EMPTY.withColor(6445145), 0.3f, Map.of(EnumArmorMaterial.NETHERITE, "netherite_darker"));
        TrimMaterials.register(var0, REDSTONE, Items.REDSTONE, ChatModifier.EMPTY.withColor(9901575), 0.4f);
        TrimMaterials.register(var0, COPPER, Items.COPPER_INGOT, ChatModifier.EMPTY.withColor(11823181), 0.5f);
        TrimMaterials.register(var0, GOLD, Items.GOLD_INGOT, ChatModifier.EMPTY.withColor(14594349), 0.6f, Map.of(EnumArmorMaterial.GOLD, "gold_darker"));
        TrimMaterials.register(var0, EMERALD, Items.EMERALD, ChatModifier.EMPTY.withColor(1155126), 0.7f);
        TrimMaterials.register(var0, DIAMOND, Items.DIAMOND, ChatModifier.EMPTY.withColor(7269586), 0.8f, Map.of(EnumArmorMaterial.DIAMOND, "diamond_darker"));
        TrimMaterials.register(var0, LAPIS, Items.LAPIS_LAZULI, ChatModifier.EMPTY.withColor(4288151), 0.9f);
        TrimMaterials.register(var0, AMETHYST, Items.AMETHYST_SHARD, ChatModifier.EMPTY.withColor(10116294), 1.0f);
    }

    public static Optional<Holder.c<TrimMaterial>> getFromIngredient(IRegistryCustom var0, ItemStack var12) {
        return var0.registryOrThrow(Registries.TRIM_MATERIAL).holders().filter(var1 -> var12.is(((TrimMaterial)var1.value()).ingredient())).findFirst();
    }

    private static void register(BootstapContext<TrimMaterial> var0, ResourceKey<TrimMaterial> var1, Item var2, ChatModifier var3, float var4) {
        TrimMaterials.register(var0, var1, var2, var3, var4, Map.of());
    }

    private static void register(BootstapContext<TrimMaterial> var0, ResourceKey<TrimMaterial> var1, Item var2, ChatModifier var3, float var4, Map<EnumArmorMaterial, String> var5) {
        TrimMaterial var6 = TrimMaterial.create(var1.location().getPath(), var2, var4, IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("trim_material", var1.location())).withStyle(var3), var5);
        var0.register(var1, var6);
    }

    private static ResourceKey<TrimMaterial> registryKey(String var0) {
        return ResourceKey.create(Registries.TRIM_MATERIAL, new MinecraftKey(var0));
    }
}

