/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.MobEffect;

public class PotionRegistry {
    @Nullable
    private final String name;
    private final ImmutableList<MobEffect> effects;

    public static PotionRegistry byName(String var0) {
        return BuiltInRegistries.POTION.get(MinecraftKey.tryParse(var0));
    }

    public PotionRegistry(MobEffect ... var0) {
        this((String)null, var0);
    }

    public PotionRegistry(@Nullable String var0, MobEffect ... var1) {
        this.name = var0;
        this.effects = ImmutableList.copyOf((Object[])var1);
    }

    public String getName(String var0) {
        return var0 + (this.name == null ? BuiltInRegistries.POTION.getKey(this).getPath() : this.name);
    }

    public List<MobEffect> getEffects() {
        return this.effects;
    }

    public boolean hasInstantEffects() {
        if (!this.effects.isEmpty()) {
            for (MobEffect var1 : this.effects) {
                if (!var1.getEffect().isInstantenous()) continue;
                return true;
            }
        }
        return false;
    }
}

