/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemToolMaterial;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;

public class ItemSword
extends ItemToolMaterial
implements ItemVanishable {
    private final float attackDamage;
    private final Multimap<AttributeBase, AttributeModifier> defaultModifiers;

    public ItemSword(ToolMaterial var0, int var1, float var2, Item.Info var3) {
        super(var0, var3);
        this.attackDamage = (float)var1 + var0.getAttackDamageBonus();
        ImmutableMultimap.Builder var4 = ImmutableMultimap.builder();
        var4.put((Object)GenericAttributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        var4.put((Object)GenericAttributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)var2, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = var4.build();
    }

    public float getDamage() {
        return this.attackDamage;
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        if (var1.is(Blocks.COBWEB)) {
            return 15.0f;
        }
        Material var2 = var1.getMaterial();
        if (var2 == Material.PLANT || var2 == Material.REPLACEABLE_PLANT || var1.is(TagsBlock.LEAVES) || var2 == Material.VEGETABLE) {
            return 1.5f;
        }
        return 1.0f;
    }

    @Override
    public boolean hurtEnemy(ItemStack var02, EntityLiving var1, EntityLiving var2) {
        var02.hurtAndBreak(1, var2, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean mineBlock(ItemStack var02, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        if (var2.getDestroySpeed(var1, var3) != 0.0f) {
            var02.hurtAndBreak(2, var4, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public boolean isCorrectToolForDrops(IBlockData var0) {
        return var0.is(Blocks.COBWEB);
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> getDefaultAttributeModifiers(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.getDefaultAttributeModifiers(var0);
    }
}

