/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFireworksCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class ItemFireworks
extends Item {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final String TAG_FIREWORKS = "Fireworks";
    public static final String TAG_EXPLOSION = "Explosion";
    public static final String TAG_EXPLOSIONS = "Explosions";
    public static final String TAG_FLIGHT = "Flight";
    public static final String TAG_EXPLOSION_TYPE = "Type";
    public static final String TAG_EXPLOSION_TRAIL = "Trail";
    public static final String TAG_EXPLOSION_FLICKER = "Flicker";
    public static final String TAG_EXPLOSION_COLORS = "Colors";
    public static final String TAG_EXPLOSION_FADECOLORS = "FadeColors";
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public ItemFireworks(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        if (!var1.isClientSide) {
            ItemStack var2 = var0.getItemInHand();
            Vec3D var3 = var0.getClickLocation();
            EnumDirection var4 = var0.getClickedFace();
            EntityFireworks var5 = new EntityFireworks(var1, var0.getPlayer(), var3.x + (double)var4.getStepX() * 0.15, var3.y + (double)var4.getStepY() * 0.15, var3.z + (double)var4.getStepZ() * 0.15, var2);
            var1.addFreshEntity(var5);
            var2.shrink(1);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        if (var1.isFallFlying()) {
            ItemStack var3 = var1.getItemInHand(var2);
            if (!var0.isClientSide) {
                EntityFireworks var4 = new EntityFireworks(var0, var3, var1);
                var0.addFreshEntity(var4);
                if (!var1.getAbilities().instabuild) {
                    var3.shrink(1);
                }
                var1.awardStat(StatisticList.ITEM_USED.get(this));
            }
            return InteractionResultWrapper.sidedSuccess(var1.getItemInHand(var2), var0.isClientSide());
        }
        return InteractionResultWrapper.pass(var1.getItemInHand(var2));
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        NBTTagList var5;
        NBTTagCompound var4 = var0.getTagElement(TAG_FIREWORKS);
        if (var4 == null) {
            return;
        }
        if (var4.contains(TAG_FLIGHT, 99)) {
            var2.add(IChatBaseComponent.translatable("item.minecraft.firework_rocket.flight").append(CommonComponents.SPACE).append(String.valueOf(var4.getByte(TAG_FLIGHT))).withStyle(EnumChatFormat.GRAY));
        }
        if (!(var5 = var4.getList(TAG_EXPLOSIONS, 10)).isEmpty()) {
            for (int var6 = 0; var6 < var5.size(); ++var6) {
                NBTTagCompound var7 = var5.getCompound(var6);
                ArrayList var8 = Lists.newArrayList();
                ItemFireworksCharge.appendHoverText(var7, var8);
                if (var8.isEmpty()) continue;
                for (int var9 = 1; var9 < var8.size(); ++var9) {
                    var8.set(var9, IChatBaseComponent.literal("  ").append((IChatBaseComponent)var8.get(var9)).withStyle(EnumChatFormat.GRAY));
                }
                var2.addAll(var8);
            }
        }
    }

    public static void setDuration(ItemStack var0, byte var1) {
        var0.getOrCreateTagElement(TAG_FIREWORKS).putByte(TAG_FLIGHT, var1);
    }

    @Override
    public ItemStack getDefaultInstance() {
        ItemStack var0 = new ItemStack(this);
        ItemFireworks.setDuration(var0, (byte)1);
        return var0;
    }

    public static final class EffectType
    extends Enum<EffectType> {
        public static final /* enum */ EffectType SMALL_BALL = new EffectType(0, "small_ball");
        public static final /* enum */ EffectType LARGE_BALL = new EffectType(1, "large_ball");
        public static final /* enum */ EffectType STAR = new EffectType(2, "star");
        public static final /* enum */ EffectType CREEPER = new EffectType(3, "creeper");
        public static final /* enum */ EffectType BURST = new EffectType(4, "burst");
        private static final IntFunction<EffectType> BY_ID;
        private final int id;
        private final String name;
        private static final /* synthetic */ EffectType[] i;

        public static EffectType[] values() {
            return (EffectType[])i.clone();
        }

        public static EffectType valueOf(String var0) {
            return Enum.valueOf(EffectType.class, var0);
        }

        private EffectType(int var2, String var3) {
            this.id = var2;
            this.name = var3;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static EffectType byId(int var0) {
            return BY_ID.apply(var0);
        }

        private static /* synthetic */ EffectType[] c() {
            return new EffectType[]{SMALL_BALL, LARGE_BALL, STAR, CREEPER, BURST};
        }

        static {
            i = EffectType.c();
            BY_ID = ByIdMap.continuous(EffectType::getId, EffectType.values(), ByIdMap.a.ZERO);
        }
    }
}

