/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ItemBookAndQuill
extends Item {
    public ItemBookAndQuill(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (var3.is(Blocks.LECTERN)) {
            return BlockLectern.tryPlaceBook(var0.getPlayer(), var1, var2, var3, var0.getItemInHand()) ? EnumInteractionResult.sidedSuccess(var1.isClientSide) : EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var1.openItemGui(var3, var2);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    public static boolean makeSureTagIsValid(@Nullable NBTTagCompound var0) {
        if (var0 == null) {
            return false;
        }
        if (!var0.contains("pages", 9)) {
            return false;
        }
        NBTTagList var1 = var0.getList("pages", 8);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            String var3 = var1.getString(var2);
            if (var3.length() <= Short.MAX_VALUE) continue;
            return false;
        }
        return true;
    }
}

